<?php

namespace App\Http\Controllers;

use Carbon\Carbon;
use App\Models\Donor;
use Illuminate\Http\Request;
use App\Http\Requests\BloodDonorRequest;


class BloodDonorController extends Controller
{

    public function index() 
    {
        $donors = Donor::all();
        return response()->json($donors);
    }
    public function store(BloodDonorRequest $request)
    {
        // Retrieve validated data
        $validatedData = $request->validated();

        // Convert date_of_birth to MySQL format (YYYY-MM-DD)
        $validatedData['date_of_birth'] = Carbon::createFromFormat('d/m/Y', $validatedData['date_of_birth'])->format('Y-m-d');

        // Create the donor
        $donor = Donor::create($validatedData);

        return response()->json([
            'status'  => 'success',
            'message' => 'Donor registered successfully.',
            'data'    => $donor,
        ], 201);
    }
}
