<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class CurrencyRateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'base_currency' => 'required|string|size:3|alpha', // Validates a 3-letter currency code
            'quote_currency' => 'required|string|size:3|alpha', // Validates a 3-letter currency code
         
        ];
    }
    public function messages(): array
    {
        return [
            'base_currency.required' => 'Base currency is required.',
            'base_currency.size' => 'Base currency must be a 3-letter code.',
            'base_currency.alpha' => 'Base currency must only contain letters.',

            'quote_currency.required' => 'Quote currency is required.',
            'quote_currency.size' => 'Quote currency must be a 3-letter code.',
            'quote_currency.alpha' => 'Quote currency must only contain letters.',

          
        ];
    }
}
