<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use App\Services\VisaExchangeRateService;
use App\Services\CurrencyConverterService;
use App\Services\MasterCardConversionRates;
use App\Repositories\CurrencyRateRepository;


class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        $this->app->bind(CurrencyConverterService::class, function ($app) {
            return new CurrencyConverterService($app->make(CurrencyRateRepository::class)); // ✅ Correct dependency
        });
        $this->app->bind(CurrencyRateRepository::class, function ($app) {
            return new CurrencyRateRepository();
        });
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        //
    }
}
