<?php

namespace App\Repositories;

use App\Models\CreditCardCurrencyRate;
use Carbon\Carbon;

class CurrencyRateRepository
{
    /**
     * Find the conversion rate for a given base and quote currency.
     * 
     * @param string $baseCurrency
     * @param string $quoteCurrency
     * @return CreditCardCurrencyRate|null
     */
    public function findRate($baseCurrency, $quoteCurrency)
    {
        return CreditCardCurrencyRate::where('base_currency', $baseCurrency)
            ->where('quote_currency', $quoteCurrency)
            ->where('quote_date', Carbon::today()->toDateString())
            ->first();
    }

    /**
     * Save the conversion rate for a given base and quote currency.
     * 
     * @param string $baseCurrency
     * @param string $quoteCurrency
     * @param float $conversionRate
     * @param string $source
     * @return CreditCardCurrencyRate
     */
    public function saveRate($baseCurrency, $quoteCurrency, $conversionRate, $source)
    {
        return CreditCardCurrencyRate::create([
            'quote_date' => Carbon::today()->toDateString(),
            'base_currency' => $baseCurrency,
            'quote_currency' => $quoteCurrency,
            'conversion_rate' => $conversionRate,
            'data_source' => $source,
        ]);
    }
}
