<?php

namespace App\Services;

use GuzzleHttp\Client;
use GuzzleHttp\Exception\GuzzleException;
use Illuminate\Support\Facades\Log;

class MasterCardConversionRates
{
    protected $client;

    public function __construct()
    {
        $this->client = new Client();
    }

    private function buildUrl($transCurr, $crdhldBillCurr, $transAmt = "1", $fxDate = "0000-00-00", $bankFee = "0")
    {
        $url = "https://www.mastercard.us/settlement/currencyrate/conversion-rate";

        $params = [
            "fxDate" => $fxDate,
            "transCurr" => $transCurr,
            "crdhldBillCurr" => $crdhldBillCurr,
            "bankFee" => $bankFee,
            "transAmt" => $transAmt
        ];

        $url .= "?" . http_build_query($params);

        return $url;
    }

    public function getRates($transCurr, $crdhldBillCurr, $transAmt = "1", $fxDate = "0000-00-00", $bankFee = "0")
    {
        $url = $this->buildUrl($transCurr, $crdhldBillCurr, $transAmt, $fxDate, $bankFee);
        $referrer = "https://www.mastercard.com/content/mastercardcom/global/en/personal/get-support/convert-currency.html";
        $ua = $this->get_random_user_agent();

        try {
            // Log the request being made
            Log::info('Request to Mastercard conversion rate API', [
                'url' => $url,
                'referrer' => $referrer,
                'user-agent' => $ua
            ]);

            $response = $this->client->get($url, [
                'headers' => [
                    'Accept' => 'application/json',
                    'Referer' => $referrer,
                    'User-Agent' => $ua
                ],
                'params' => []
            ]);

            $responseBody = $response->getBody()->getContents();

            // Log the successful response
            Log::info('Mastercard conversion rate API response', [
                'response' => $responseBody
            ]);

            return json_decode($responseBody, true);
        } catch (GuzzleException $e) {
            // Log the error
            Log::error('Error while making request to Mastercard conversion rate API', [
                'error' => $e->getMessage(),
                'url' => $url
            ]);

            return ['error' => 'Unable to retrieve conversion rates'];
        }
    }

    public function get_random_user_agent()
    {
        $user_agents = [
            "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Safari/537.36",
            "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/127.0.0.0 Safari/537.36",
            "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Safari/537.36",
            "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/127.0.0.0 Safari/537.36",
            "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:129.0) Gecko/20100101 Firefox/129.0",
            "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:130.0) Gecko/20100101 Firefox/130.0",
            "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Safari/537.36 Edg/128.0.0.0",
            "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Safari/537.36",
            "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/127.0.0.0 Safari/537.36",
            "Mozilla/5.0 (X11; Linux x86_64; rv:129.0) Gecko/20100101 Firefox/129.0",
            "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/17.6 Safari/605.1.15",
            "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.15; rv:129.0) Gecko/20100101 Firefox/129.0"
        ];

        return ($user_agents[array_rand($user_agents)]);
    }
}
