<?php

namespace App\Services;

use GuzzleHttp\Client;
use GuzzleHttp\Exception\GuzzleException;

class VisaExchangeRateService
{
    protected $client;

    public function __construct()
    {
        $this->client = new Client();
    }

    /**
     * Build the URL with query parameters
     */
    private function buildUrl($amount = 1, $fee = 0, $utcConvertedDate = "09%2F17%2F2024", $exchangedate = "09%2F17%2F2024", $fromCurr = "BDT", $toCurr = "USD")
    {
        $url = "https://www.visa.ca/cmsapi/fx/rates";

        $params = [
            "amount" => $amount,
            "fee" => $fee,
            "utcConvertedDate" => $utcConvertedDate,
            "exchangedate" => $exchangedate,
            "fromCurr" => $fromCurr,
            "toCurr" => $toCurr
        ];

        $url .= "?" . http_build_query($params);

        return $url;
    }

    /**
     * Get exchange rates using Visa API
     */
    public function getExchangeRate($amount = 1, $fee = 0, $utcConvertedDate = "09%2F17%2F2024", $exchangedate = "09%2F17%2F2024", $fromCurr = "BDT", $toCurr = "USD")
    {
        $url = $this->buildUrl($amount, $fee, $utcConvertedDate, $exchangedate, $fromCurr, $toCurr);
        
        try {
            $response = $this->client->get($url, [
                'headers' => [
                    'Accept' => 'application/json, text/plain, */*',
                    'Accept-Language' => 'en-US,en;q=0.9,bn;q=0.8',
                    'Cookie' => 'YOUR_COOKIE_HERE',
                    'Priority' => 'u=1, i',
                    'Referer' => 'https://www.visa.ca/en_CA/support/consumer/travel-support/exchange-rate-calculator.html',
                    'Sec-Ch-Ua' => '"Chromium";v="128", "Not;A=Brand";v="24", "Google Chrome";v="128"',
                    'Sec-Ch-Ua-Mobile' => '?0',
                    'Sec-Ch-Ua-Platform' => '"macOS"',
                    'Sec-Fetch-Dest' => 'empty',
                    'Sec-Fetch-Mode' => 'cors',
                    'Sec-Fetch-Site' => 'same-origin',
                    'User-Agent' => 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Safari/537.36'
                ]
            ]);

            // Return the response data as a decoded JSON array
            return json_decode($response->getBody()->getContents(), true);

        } catch (GuzzleException $e) {
            // Handle any errors or exceptions
            return ['error' => $e->getMessage()];
        }
    }
}
