import requests
import json
import sys
import logging

# Get arguments from the command line
amount = sys.argv[1] if len(sys.argv) > 1 else 1
from_currency = sys.argv[2] if len(sys.argv) > 2 else 'BDT'
to_currency = sys.argv[3] if len(sys.argv) > 3 else 'USD'

# Fixed values for other parameters
fee = 0
utc_converted_date = '09/17/2024'  # Fixed date
exchange_date = '09/17/2024'       # Fixed date

# Construct the URL with dynamic values
url = f"https://www.visa.ca/cmsapi/fx/rates?amount={amount}&fee={fee}&utcConvertedDate={utc_converted_date}&exchangedate={exchange_date}&fromCurr={from_currency}&toCurr={to_currency}"

# Headers for the request
headers = {
    'accept': 'application/json, text/plain, */*',
    'accept-language': 'en-US,en;q=0.9,bn;q=0.8',
    'cookie': '_cfuvid=GYrjw9tBRENZNTAQknB.JEXY7_jdqQ.T0QqEkQ_DNMk-1726620849701-0.0.1.1-604800000; _cs_mk=0.19909863164112407_1726620861780; _gid=GA1.2.541821837.1726620862; wscrCookieConsent=1=true&2=true&3=true&4=true&5=true&visitor=b743ffc3-f433-4e04-8608-bd9ae2f77d6a&version=20240917-001&consent=explicit; _cs_c=0; _cs_id=b8848837-2e7f-abd3-e019-9f786a9ef1a1.1726620862.1.1726620862.1726620862.1.1760784862121.1; _gcl_au=1.1.709879946.1726620862; _ga=GA1.1.731355209.1726620862; lbs=!DOEGwTrvpX0hX5uCWW0fbBXS8ZnHLllsVC0Ae970BlJIahLcl1WAjiTcPo1rKi8f/r2VehsLKYJ7x8QNo4sK/alBM9j5zYatQCT/3C3o; _cs_s=1.0.0.1726622692210; _ga_NE478XKGTR=GS1.1.1726620862.1.1.1726620909.13.0.0; _ga_MFHD9HS65Z=GS1.1.1726620862.1.1.1726620909.13.0.0; utag_main=v_id:0192029f54ba001de327f55ff33505075005706d0093c$_sn:1$_se:15$_ss:0$_st:1726622709394$ses_id:1726620849340%3Bexp-session$_pn:1%3Bexp-session$_prevpage:www.visa.ca%2Fen_CA%2Fsupport%2Fconsumer%2Ftravel-support%2Fexchange-rate-calculator.html%3Bexp-1726624509423',
    'priority': 'u=1, i',
    'referer': 'https://www.visa.ca/en_CA/support/consumer/travel-support/exchange-rate-calculator.html',
    'sec-ch-ua': '"Chromium";v="128", "Not;A=Brand";v="24", "Google Chrome";v="128"',
    'sec-ch-ua-mobile': '?0',
    'sec-ch-ua-platform': '"macOS"',
    'sec-fetch-dest': 'empty',
    'sec-fetch-mode': 'cors',
    'sec-fetch-site': 'same-origin',
    'user-agent': 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Safari/537.36'
}

# Send the request to the Visa API
response = requests.get(url, headers=headers)

# Check if the response is successful
if response.status_code == 200:
    try:
        data = response.json()
        # You can log the response or print it to return the rate
        print(json.dumps(data, indent=4))
    except json.JSONDecodeError:
        logging.error("Error parsing JSON response from Visa API.")
        print({"error": "Unable to parse response"})
else:
    logging.error(f"Request failed with status code: {response.status_code}")
    print({"error": f"Request failed with status code {response.status_code}"})
