
@section('title', $title)
@section('description', $description)
@extends('layouts.app')

@section('content')
<section class="bg-[#f5f8fa]">
    <div class=" max-width px-[3%] min-xl:mx-auto  min-xl:px-0">
        <h3 class="py-4">About Thalassemia</h3>
        <!--Banner-->
        <div class="min-lg:mt-10">
            <img src="{{ asset('assets/img/banner/003.png') }}" alt="">
        </div>
        <!--Banner-->
        <h4 class="py-5">
           What is thalassemia?
        </h4>

        <p >Thalassemia is a very common blood disorder in Bangladesh. It is caused by a genetic mutation that results in defective hemoglobin production. The disease manifests as severe anemia in early childhood, usually between 1-3 years of age. The typical symptoms are pallor, jaundice, frequent infections, poor appetite, irritability, poor growth, and abdominal distension.</p>

        <h4 class="py-5">
           What is it’s treatment?
        </h4>
        <p>
            The treatment of thalassemia is regular blood transfusion at 2-4 week intervals to correct the anemia. A safe and
            sustainable supply of blood is needed to cater the thalassemia patients.&nbsp;&nbsp; Ideally, the patients need
            leuko-reduced (free of white blood cells) red blood cell. Alternatively, a bedside leukoreduction filter is used
            to reduce the white cells from blood. A significant number of patients contract transfusion-transmitted infection
            such as Hepatitis B and C.
        </p>
        <p class="pt-7">
            Chronic blood transfusion results in toxic iron accumulation in vital organs of the patient such as liver, heart,
            and pancreas. &nbsp;The iron overload gives rise to further complications such as heart failure, liver cirrhosis,
            diabetes, and growth retardation. Consequently, the patients have to take iron reducing medications throughout
            their lives to mitigate the iron toxicity. The currently available medications are desferrioxamine, deferiprone,
            and deferasirox. Desferrioxamine is available only in injectable form and must be taken subcutaneously with a portable
            infusion pump over 8-12 hours for 5 days/week.
        </p>
        <h4 class="py-5">
            Is there any cure?
        </h4>
        <p>
            The only cure for thalassemia is bone marrow transplantation (BMT). But its potential widespread application is limited
            by several factors. Firstly, BMT for thalassemia requires a matched sibling donor. Such donor is available in only
            1-2% families. Secondly, there is a significant mortality and rejection risk associated with BMT compared to conventional
            treatment with blood transfusion. It is also an expensive procedure and most families cannot afford it.
        </p>
        <h4 class="py-5">
           How can it be prevented?
        </h4>
        <p class="pb-7">
            Thalassemia is a preventable disease. The disease only occurs when both the parents carry the thalassemia gene. In
            such families, the probability of having a thalassemia affected baby in each pregnancy is 25%. However, if either
            partner is healthy, children will not be affected at all.
        </p>
        <!--Content-->
    </div>

</section>
@endsection
