@section('title', $title)
@section('description', $description)
@extends('layouts.app')

@section('content')
    <section class="bg-[#f5f8fa]">
        <div class=" max-width px-[3%] min-xl:mx-auto  min-xl:px-0">
            <h3 class="py-4">Support US</h3>
            <!--Banner-->
            <div class="min-lg:pt-9">
                <img src="{{ asset('assets/img/banner/support_us.png') }}" alt="">
            </div>
            <!--Banner-->
            <!--Content-->
            <div class="py-10 ">
                <p class=" text-justify">We provide support to poor and marginalized patients who cannot afford treatment.
                    These
                    supports are made possible by the donation of philanthropic individuals and organizations. You can also
                    contribute.</p>
                <br>
                <h4 class="">Donate Your Zakat</h4>
                <p>Zakat fund is the lifeline for a large number of patients. Poor patients get partial to full treatment
                    cost
                    subsidized by Zakat fund.</p>

                <p class="mt-5">Our zakat fund bank account –</p>

                <h5 class="mt-5"><strong>Bangladesh Thalassemia Foundation - Zakat Fund</strong></h5>
                <ul class="">

                    <li>AC# 20501450100519315</li>
                    <li>Islami Bank Bangladesh Limited</li>
                    <li>Mouchak Branch, Dhaka</li>
                    <li>Routing no: 125274395</li>
                    <li>Swift code: IBBLBDDH</li>
                </ul>
                <h5 class="mt-5"><strong>Mobile banking</strong> </h5>
                <ul class="">
                    <li>Bkash Merchant Account: 01678310930</li>
                    <li>(use menu 3-Payment, counter '0’)</li>
                </ul>
                <p class="pt-6 pb-4">You can also donate Zakat using a VISA or MasterCard in the following link-</p>
                {{-- <div class="text-center mt-5 hidden min-md:block"> --}}
                    <a class="btn btn-primary mt-5 xs:px-[2px] xs:text-[10px] px-4 hover:text-white " href="{{ env('EXTERNAL_URL') }}/campaign/together-against-thalassemia-20"> Donate Online</a>
                {{-- </div> --}}
                <p class="text-[#ce1337] py-5 font-semibold">Sponsor a patient</p>

                <p>You can sponsor a child’s treatment fully or partially. The monthly cost of treatment of a thalassemia
                    patient is about 5000Tk. (62.5 USD). This amount covers for the following –</p>

                <div class="py-8">
                    <table class="w-full border-collapse border border-borderTable">
                        <thead>
                            <tr>
                                <th class="text-left p-2 border border-borderTable">Item</th>
                                <th class="text-left p-2 border border-borderTable">Unit</th>
                                <th class="text-left p-2 border border-borderTable">Cost</th>
                                <th class="text-left p-2 border border-borderTable">Cost USD</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td class="text-left p-2 border border-borderTable">Blood transfusion</td>
                                <td class="text-left p-2 border border-borderTable">1 bag</td>
                                <td class="text-left p-2 border border-borderTable">1500tk</td>
                                <td class="text-left p-2 border border-borderTable">18.75$</td>
                            </tr>
                            <tr>
                                <td class="text-left p-2 border border-borderTable">Medicine (iron chelators)</td>
                                <td class="text-left p-2 border border-borderTable">1 month</td>
                                <td class="text-left p-2 border border-borderTable">3000tk</td>
                                <td class="text-left p-2 border border-borderTable">37.5$</td>
                            </tr>
                            <tr>
                                <td class="text-left p-2 border border-borderTable">Investigation</td>
                                <td class="text-left p-2 border border-borderTable">1 bag</td>
                                <td class="text-left p-2 border border-borderTable">500tk</td>
                                <td class="text-left p-2 border border-borderTable">6.15$</td>
                            </tr>
                        </tbody>
                        <tfoot>
                            <tr class="">
                                <td class="text-left p-2 font-semibold border border-borderTable">Total</td>
                                <td class="text-left p-2 border border-borderTable"></td>
                                <td class="text-left p-2 font-semibold border border-borderTable">5000tk</td>
                                <td class="text-left p-2 font-semibold border border-borderTable">62.5$</td>
                            </tr>
                        </tfoot>
                    </table>
                </div>
                <!--Bank Accounts-->
                <div
                    class="min-md:grid min-md:grid-cols-[48%,48%] min-lg:grid-cols-[33%,30%,33%,] gap-6 py-4 mt-10   min-2xl:px-0 ">
                    <div>
                        <p><strong>IFIC Bank </strong></p>
                        <ul>
                            <li>A/C Name: Bangladesh Thalassemia Foundation</li>
                            <li>Account Number: 1007200110001</li>
                            <p>IFIC Bank, Shantinagar Branch </p>
                            <p>Routing Number: 120276343</p>
                            <p>SWIFT Code: IFICBDDH</p>
                        </ul>
                    </div>
                    <div>
                        <p><strong>National Credit and Commerce Bank </strong></p>
                        <ul>
                            <li>A/C Name: Bangladesh Thalassemia Foundation </li>
                            <li>Account Number: 00100210010690 </li>
                            <li>NCC Bank, Dhanmondi Branch </li>
                            <li>Routing Number: 160261189 </li>
                            <li>SWIFT Code: NCCLBDDHDMB</li>
                        </ul>
                    </div>
                    <div>
                        <p><strong>Eastern Bank Ltd.</strong></p>
                        <ul>
                            <li>A/C Name: Thalassemia Foundation Hospital </li>
                            <li>Account Number: 1141070093410</li>
                            <li>Eastern Bank Ltd., Shantinagar Branch</li>
                            <li>Routing Number: 095276344 </li>
                            <li>SWIFT Code: EBLDBDDH</li>
                        </ul>
                    </div>
                    <div>
                        <p><strong>Mobile banking.</strong></p>
                        <ul>
                            <li>bKash Merchant Account: 01729284257</li>
                            <li>(use menu 3-Payment, counter '0’)</li>
                            <li>Eastern Bank Ltd., Shantinagar Branch</li>
                            <li>Routing Number: 095276344 </li>
                            <li>SWIFT Code: EBLDBDDH</li>
                        </ul>
                    </div>
                </div>

                <p class="py-6">You can also donate Zakat using a VISA or MasterCard in the following link-</p>

                {{-- <a href="#" class="btn btn-primary">Sponsor A Child Online</a> --}}
                {{-- <div class="text-center mt-5 hidden min-md:block"> --}}
                    <a class="btn btn-primary mt-5 xs:px-[2px] xs:text-[10px] px-4 hover:text-white " href="{{ env('EXTERNAL_URL') }}/campaign/together-against-thalassemia-20">Sponsor A Child Online</a>
                {{-- </div> --}}

                <h4 class="text-[#ce1337] my-7">Donate blood</h4>

                <p>Thalassemia patient lives by taking 1-2 bags of blood every month. We do about 600 blood transfusions
                    every month. You can donate blood every three months.</p>
            </div>
            <!--Content-->
        </div>

    </section>
@endsection
