@section('title', $title)
@section('description', $description)
@extends('layouts.app')

@section('content')
    <section class="bg-[#f5f8fa]">
         <div class="max-width px-[3%] min-xl:mx-auto  min-xl:px-0">
            <h3 class="text-inline pt-[80px] min-lg:pt-[120px] pb-4">National Workshop on Clinical Management of Thalassemia</h3>
            <!--Banner-->
            <div class="">
                <img src="{{ asset('assets/img/banner/workshop_banner.jpg') }}" alt="workshop_banner">
            </div>
            <!--Banner-->
            {{-- <div class="my-0 bg-primary space-x-4 text-white px-5 py-2">
                <a href="">Download Slides </a>
                <a href="">Program Details </a>
                <a href="">Program schedule </a>
            </div> --}}
            <!--Content-->
            <div>
                <h4 class="pt-5 pb-3">Background</h4>
                <p>Thalassemia is a very common hereditary blood disorder. It is caused by defects in the beta-globin gene
                    resulting in a qualitative and quantitative defect in hemoglobin production. The affected patients suffer
                    from severe anemia.</p>
                <br>
                <p>The management of Thalassemia involves regular blood transfusion, iron chelation, and management of its
                    complications. The treatment is tailored according to clinical severity and following a multidisciplinary
                    approach.</p>
                <br>
                <p>Bangladesh is one of the highly thalassemia affected countries with 7% of the population being thalassemia
                    trait. It is estimated that 7,000 babies are born with thalassemia every year and the total number of
                    patients is 60,000.</p>
                <br>
                <p>Though quite common, the management practice of thalassemia in Bangladesh did not evolve as expected. The
                    treatment widely varies between specialists, hospitals, and parts of the county due to resource limitation,
                    lack of knowledge and a standard practice guideline.</p>
                <br>
                <p>The workshop aims to provide an essential overview on the application of the standard guideline in the
                    management of thalassemia in a resource-constrained setting.</p>
            </div>
            <!--Program Details-->
            <div class="py-10 flex justify-between">
                <div class="flex-1">
                    <p><strong>Venue</strong> Bangladesh College of Physicians and Surgeons Auditorium, Mohakhali, Dhaka</p>
                    <p><strong>Date</strong> November 11, 2018</p>
                    <p><strong>Time</strong> 8:00 am – 5:00 pm</p>
                    <p><strong>Registration Fee</strong> 500tk<span>(Lunch and snacks will be provided at the venue)</span></p>
                    <p><strong>Payment option</strong> bKash number- 01729284257 & cash</p>

                    <div class="pt-5">
                        <p><strong>Chief Guest: </strong> Md. Nasim, MP, Honorable Minister
                            Ministry of Health and Family Welfare</p>
                      <div>
                        <img src="{{ asset('assets/img/md_nasim.jpg') }}" class="sm:h-[200px] sm:w-[200px] h-[250px] w-[250px]" alt="">
                      </div>
                    </div>
                </div>
                <div class="flex-[2]">
                    <iframe
                        src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3651.1444269542553!2d90.396231!3d23.777870800000006!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x3755c76f293b6a5f%3A0xc58a70832f7d8247!2sBangladesh+College+of+Physicians+and+Surgeons+(BCPS)!5e0!3m2!1sen!2sbd!4v1540804097918"
                        class="w-full h-72 border-0"
                        allowfullscreen
                        loading="lazy">
                    </iframe>
                </div>
            </div>

            <!--Program Details-->
            <!--Program schedule-->
            <div>
                <h3 class="mt-10 mb-5">Program Schedule</h3>
                <h4 class="mb-3">International Guidelines</h4>
                <p class="text-[#f25f43] hover:text-[#b68023] hover:underline "><a
                        href="{{ asset('storage/guidelines/TDT Guideline, 3rd Ed.pdf') }}">Guidelines for the Management of
                        Transfusion Dependent Thalassaemia (3rd Edition)</a></p>
                <p class="text-[#f25f43] hover:text-[#b68023] hover:underline pt-3 pb-5"><a
                        href="{{ asset('storage/guidelines/NTDT Guideline, 2nd Ed.pdf') }}">Guidelines for the Management of
                        Non-Transfusion Dependent Thalassaemias (2nd edition)</a></p>
                <h4>Powerpoint slide download</h4>
                <p>If you want to download individual slides, please cick on the respective topic.</p>

                <p class="text-[#f25f43] hover:text-[#b68023] hover:underline my-3"><a
                        href="{{ asset('storage/workshop2018/All Slides - Clinical Management of Thalassemia Workshop 2018.zip') }}">Click
                        here to download all slides.</a></p>

                <div class=" mt-4 ">
                    <table class="border-collapse border border-black w-full px-3  rounded-lg text-sm">
                        <thead>
                            <tr class="bg-[#ce1337] text-white border border-black ">
                                <th class="border-l-[1px] border-black  px-4 py-2">Time</th>
                                <th class="border border-black px-2 py-2">Topics</th>
                                <th class="border border-black px-2 py-2">Speakers</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td class="border border-black  px-2 py-2">08:00 AM</td>
                                <td class="border border-black  px-2 py-2">Registration and reception, Welcome tea/coffee and snacks</td>
                                <td class="border border-black  px-4 py-2"></td>
                            </tr>
                            <tr class="">
                                <td class="border border-black px-2 py-2">08:30 AM</td>
                                <td class="border border-black px-2 py-2 font-bold text-[#f25f43] hover:text-[#b68023] hover:underline"><a
                                        href="{{ asset('storage/workshop2018/1. Session 1 - Pathophysiology and classification of thalassemia - Prof. Dr. Manzur Morshed.pptx') }}">Pathophysiology
                                            and classification of thalassemia</a></td>
                                <td class="border border-black px-2 py-2">Prof. Dr. Manzur Morshed<br>Consultant – Clinical
                                    Hematology,<br>Asgar Ali Hospital</td>
                            </tr>
                            <tr>
                                <td class="border border-black px-2 py-2">08:50 AM</td>
                                <td class="border border-black px-2 py-2 font-bold text-[#f25f43] hover:text-[#b68023] hover:underline"><a
                                        href="{{ asset('storage/workshop2018/2. Session 1 - Diagnosis of thalassemia - Dr. Akhil Ranjan Biswas.ppt') }}"><strong>Diagnosis
                                            of thalassemia</strong></a></td>
                                <td class="border border-black  px-2 py-2">Dr. Akhil Ranjan Biswas<br>Associate Professor, Bone Marrow
                                    Transplantation<br>Department of Hematology, Dhaka Medical College</td>
                            </tr>
                            <tr class="">
                                <td class="border border-black px-2 py-2">09:10 AM</td>
                                <td class="border border-black px-2 py-2 font-bold text-[#f25f43] hover:text-[#b68023] hover:underline"><a
                                        href="{{ asset('storage/workshop2018/3. Session 1 - Overview of the management of thalassemia - Prof. Manzur Morshed.pptx') }}"><strong>Overview
                                            of the management of thalassemia</strong></a></td>
                                <td class="border border-black px-2 py-2">Prof. Dr. Manzur Morshed<br>Consultant – Clinical
                                    Hematology,<br>Asgar Ali Hospital</td>
                            </tr>
                            <tr>
                                <td class="border border-black px-2 py-2">09:30 AM</td>
                                <td class="border border-black px-2 py-2">Question/Answer and Panel Discussion (Session 1)</td>
                                <td class="border border-black px-2 py-2"></td>
                            </tr>
                            <tr class="">
                                <td class="border border-black px-2 py-2">10:00 AM</td>
                                <td class="border border-black px-2 py-2">Tea break</td>
                                <td class="border border-black px-2 py-2"></td>
                            </tr>
                            <tr>
                                <td class="border border-black px-2 py-2">10:30 AM</td>
                                <td class="border border-black px-2 py-2 font-bold text-[#f25f43] hover:text-[#b68023] hover:underline"><a
                                        href="{{ asset('storage/workshop2018/4. Session 2 - Blood transfusion, Initiation and optimization - Dr. Jannatul Ferdous.pptx') }}"><strong>Blood
                                            transfusion, Initiation and optimization</strong></a></td>
                                <td class="border border-black px-2 py-2">Dr. Jannatul Ferdous<br>Associate Professor<br>Department of
                                    Transfusion Medicine, Mugda Medical College</td>
                            </tr>
                            <tr class="">
                                <td class="border border-black px-2 py-2">10:50 AM</td>
                                <td class="border border-black px-2 py-2 font-bold text-[#f25f43] hover:text-[#b68023] hover:underline"><a
                                        href="{{ asset('storage/workshop2018/5. Session 2 - Iron overload and chelation - Dr. Prosanto Chowdhury.pptx') }}"><strong>Iron
                                            overload and chelation</strong></a></td>
                                <td class="border border-black px-2 py-2">Dr. Prosanto Chowdhury<br>Consultant Haemoglobinopathy &
                                    Thalassemias,<br>The Institute of Child Health, Kolkata</td>
                            </tr>
                            <tr>
                                <td class="border border-black px-2 py-2">11:10 AM</td>
                                <td class="border border-black px-2 py-2 font-bold text-[#f25f43] hover:text-[#b68023] hover:underline"><a
                                        href="{{ asset('storage/workshop2018/6. Session 2 - Recent advances in treatment and cure - Dr. Prosanto Chowdhury.pptx') }}"><strong>Recent
                                            advances in treatment and cure</strong></a></td>
                                <td class="border border-black px-2 py-2">Do</td>
                            </tr>
                            <tr class="">
                                <td class="border border-black px-2 py-2">11:30 AM</td>
                                <td class="border border-black px-2 py-2">Question/Answer and Panel Discussion (Session 2)</td>
                                <td class="border border-black px-2 py-2"></td>
                            </tr>
                            <tr>
                                <td class="border border-black px-2 py-2">12:00 PM</td>
                                <td class="border border-black px-2 py-2">Inaugural program</td>
                                <td class="border border-black px-2 py-2"></td>
                            </tr>
                            <tr class="">
                                <td class="border border-black px-2 py-2">01:30 PM</td>
                                <td class="border border-black px-2 py-2">Lunch break</td>
                                <td class="border border-black px-2 py-2"></td>
                            </tr>
                            <tr>
                                <td class="border border-black px-2 py-2">11:30 AM</td>
                                <td class="border border-black px-2 py-2">Question/Answer and Panel Discussion (Session 2)</td>
                                <td class="border border-black px-2 py-2"></td>
                            </tr>
                            <tr>
                                <td class="border border-black px-2 py-2">12:00 PM</td>
                                <td class="border border-black px-2 py-2">Inaugural program</td>
                                <td class="border border-black px-2 py-2"></td>
                            </tr>
                            <tr>
                                <td class="border border-black px-2 py-2">01:30 PM</td>
                                <td class="border border-black px-2 py-2">Lunch break</td>
                                <td class="border border-black px-2 py-2"></td>
                            </tr>
                            <tr>
                                <td class="border border-black px-2 py-2">02:30 PM</td>
                                <td class="border border-black px-2 py-2 text-[#f25f43] hover:text-[#b68023] hover:underline"><a
                                        href="{{ asset('storage/workshop2018/7. Session 3 - Pregnancy, Fertility and Prenatal Diagnosis - Prof. Dr. Feroza Begum.pptx') }}"><strong>Pregnancy,
                                            Fertility and Prenatal Diagnosis</strong></a></td>
                                <td class="border border-black px-2 py-2">
                                    <strong>Prof. Dr. Feroza Begum</strong><br>
                                    Department of Gynecology & Obstetrics<br>
                                    Bangabandhu Sheikh Mujib Medical University
                                </td>
                            </tr>
                            <tr>
                                <td class="border border-black px-2 py-2">02:40 PM</td>
                                <td class="border border-black px-2 py-2 text-[#f25f43] hover:text-[#b68023] hover:underline"><a
                                        href="{{ asset('storage/workshop2018/8. Session 3 - Cardiac complications in Thalassemia - Dr. Saqif Shahriar.pptx') }}"><strong>Cardiac
                                            complications</strong></a></td>
                                <td class="border border-black px-2 py-2">
                                    <strong>Dr. Saqif Shahriar</strong><br>
                                    Interventional Cardiologist<br>
                                    National Institute of Cardiovascular Diseases (NICVD)
                                </td>
                            </tr>
                            <tr>
                                <td class="border border-black px-4 py-2">02:50 PM</td>
                                <td class="border border-black px-4 py-2 text-[#f25f43] hover:text-[#b68023] hover:underline"><a
                                        href="{{ asset('storage/workshop2018/9. Session 3 - Hepatic complications in Thalassemia - Prof. Dr. Md. Habibur Rahman.pptx') }}"><strong>Hepatic
                                            complications</strong></a></td>
                                <td class="border border-black px-4 py-2">
                                    <strong>Prof. Dr. Md. Habibur Rahman</strong><br>
                                    Professor and Head, Gastroenterology Department<br>
                                    SSMC & Mitford Hospital, Dhaka
                                </td>
                            </tr>
                            <tr>
                                <td class="border border-black px-4 py-2">03:00 PM</td>
                                <td class="border border-black px-4 py-2">Question/Answer and Panel Discussion (Session 3)</td>
                                <td></td>
                            </tr>
                            <tr>
                                <td class="border border-black px-4 py-2">03:15 PM</td>
                                <td class="border border-black px-4 py-2 text-[#f25f43] hover:text-[#b68023] hover:underline"><a
                                        href="{{ asset('storage/workshop2018/10. Session 4 - Endocrine complication in thalassemia and osteoporosis - Dr. Tahniyah Haq.pptx') }}"><strong>Endocrine
                                            complication and osteoporosis</strong></a></td>
                                <td class="border border-black px-4 py-2">
                                    <strong>Dr. Tahniyah Haq</strong><br>
                                    Assistant Professor<br>
                                    Department of Endocrinology<br>
                                    Bangabandhu Sheikh Mujib Medical University
                                </td>
                            </tr>
                            <tr>
                                <td class="border border-black px-4 py-2">03:25 PM</td>
                                <td class="border border-black px-4 py-2 text-[#f25f43] hover:text-[#b68023] hover:underline"><a
                                        href="{{ asset('storage/workshop2018/11. Session 4 - BMT and Thalassemia - Dr. Salahuddin Shah.pptx') }}"><strong>BMT
                                            and Thalassemia</strong></a>
                                <td class="border border-black px-4 py-2">
                                    <strong>Dr. Salahuddin Shah</strong><br>
                                    Associate Professor<br>
                                    Department of Hematology<br>
                                    Bangabandhu Sheikh Mujib Medical University
                                </td>
                            </tr>
                            <tr>
                                <td class="border border-black px-4 py-2">03:35 PM</td>
                                <td class="border border-black px-4 py-2 text-[#f25f43] hover:text-[#b68023] hover:underline"><a
                                        href="{{ asset('storage/workshop2018/12. Session 4 - Prevention of Thalassemia - Dr. Tasneem Ara.pptx') }}"><strong>Prevention
                                            of Thalassemia</strong></a>
                                <td class="border border-black px-4 py-2">
                                    <strong>Dr. Tasneem Ara</strong><br>
                                    Associate Professor<br>
                                    Department of Hematology Dhaka Medical College
                                </td>
                            </tr>
                            <tr>
                                <td class="border border-black px-4 py-2">03:45 PM</td>
                                <td class="border border-black px-4 py-2">
                                    Question/Answer and Panel Discussion (Session 4)
                                </td>
                                <td></td>
                            </tr>
                            <tr>
                                <td class="border border-black px-4 py-2">04:00 PM</td>
                                <td class="border border-black px-4 py-2">
                                    Workshop session<br>
                                    (Tea and snacks will be served during the discussion)
                                </td>
                                <td class="border border-black px-4 py-2">
                                    Diagnosis – Electrophoresis <br>
                                    Transfusion – Case <br>
                                    Chelation – Case <br>
                                    Complication – Case <br>
                                </td>
                            </tr>
                            <tr>
                                <td class="border border-black px-4 py-2">05:00 PM</td>
                                <td class="border border-black px-4 py-2">
                                    End
                                </td>
                                <td class="border border-black px-4 py-2"></td>
                            </tr>
                        </tbody>
                    </table>
                </div>
                <!--Workshop Secretariat-->
                <div class="mt-16">
                    <h3 style="margin-bottom: 10px">Workshop Secretariat</h3>
                    <p>
                        Thalassemia Foundation Hospital
                        <br>30 Chamelibagh, Shantinagar
                        <br>Dhaka – 1217, Bangladesh
                        <br><strong>Phone:</strong> +8801755587479, +88028332481, +880248316116, +88028318177, +88029334862
                        <br><strong>Email:</strong> info@thals.org
                    </p>

                    <h3 class="mb-3 mt-10">Organizers</h3>

                    <div style="padding-left: 20px">
                        <h4 style="margin-bottom: 5px">Organized by</h4>
                        <ul class="list-disc ml-5">
                            <li>Bangladesh Thalassemia Foundation</li>
                            <li>Non-communicable Disease Control Program Directorate of Health Services</li>
                        </ul>

                        <h4 class="mb-2 mt-5">Endorsed by</h4>
                        <ul class="list-disc ml-5">
                            <li>Paediatric Haematology and Oncology Society of Bangladesh (PHOSB)</li>
                            <li>Bangladesh Society of Medicine (BSM)</li>
                            <li>Obstetrical and Gynaecological Society of Bangladesh (OGSB)</li>
                            <li>Feto-Maternal Medicine Society of Bangladesh</li>
                            <li>Blood Transfusion Society of Bangladesh (BTSB)</li>
                        </ul>


                        <h4 class="mb-2 mt-5">Supported by</h4>
                        <ul class="list-disc ml-5">
                            <li>Bangladesh Thalassemia Samity Hospital</li>
                            <li>Lab One Foundation of Thalassemia (LOFT)</li>
                            <li>Medicine Club</li>
                            <li>Sandhani</li>
                            <li>iDeshi</li>
                            <li>Platform</li>
                            <li>Youth Club of Bangladesh</li>
                        </ul>
                    </div>
                </div>
                <div class="mt-10">
                    <h4 class="mt-3">Register now to attend the workshop</h4>
                    <p class="pb-7 pt-1 ">We are no longer accepting registration. Thanks.</p>
                </div>
            </div>
            <!--Program schedule-->
            <!--Content-->
         </div>
    </section>
@endsection
