<?php $__env->startSection('title', $title); ?>
<?php $__env->startSection('description', $description); ?>


<?php $__env->startSection('content'); ?>
    <section class="bg-[#f5f8fa]">
        <div class="max-width px-[3%] min-xl:mx-auto  min-xl:px-0 pb-5">
            
            <!--Banner-->
            <div class="w-full pt-[66px] min-lg:pt-[98px]">
                <img class="w-full" src="<?php echo e(asset('assets/img/banner/landing-page-banner-sumaiya.jpg')); ?>"
                    alt="landing-page-banner-sumaiya">
            </div>
            <!--Banner-->
            <!-- Main Content Wrapper-->
            <div class="min-lg:grid min-lg:grid-cols-3 gap-5 pb-10">
                <!--About Zakat Fund-->
                <div class="bg-white py-4 min-lg:max-h-[1950px]">
                    <div class="flex justify-between items-center pb-4  px-4 border-b border-[#e9eff4]">
                        <h4> About Zakat Fund</h4>
                        <a href="<?php echo e(env('EXTERNAL_URL')); ?>/campaign/together-against-thalassemia-20"
                            class="btn btn-primary hidden lg:block  xs:px-2 xs:text-[10px] px-4 hover:text-white"> I Want To
                            Donate</a>
                    </div>
                    
                    <p class="pt-5  px-4">Thalassemia patients need a life-long monthly blood transfusions and expensive
                        medications to survive. Most of the patients at our hospital are poor and cannot afford sufficient
                        treatment and thereby, becomes chronically ill. We collect zakat to support these patients with
                        life-saving treatments.</p>

                    <p class="pt-6 pb-3  px-4">Every year, during the Holy Ramadan, we appeal to the affluent people in
                        society to
                        donate their zakat to our poor patients. People donated generously and our zakat collection has
                        grown considerably over the years with which we are supporting more and more patients.</p>

                    <img src="assets/img/chart/zakatcollection2024.jpg" alt="zakat collection" class="mt-5  px-4">
                    <p class="pt-5 px-4">The fund is governed by a zakat management committee consisting of representatives
                        from patients,
                        guardians, doctors, nurses, and a religious scholar. You can read our zakat distribution policy in
                        the link below.</p>


                    <ul class="pl-10 pt-5 text-primary list-disc">
                        <li><a href="<?php echo e(asset('/zakat_managment/Zakat-Policy-2019.pdf')); ?>">Zakat Policy</a><br>
                        </li>
                        <li><a href="<?php echo e(asset('/zakat_managment/Zakat-Committee-2021.jpg')); ?>">Zakat
                                Committee 2021</a><br></li>
                        <li><a href="<?php echo e(asset('/zakat_managment/Financial-aid-application-form-2021.pdf')); ?>">Financial Aid
                                (+Zakat) Application Form</a><br></li>

                        <li><a href="<?php echo e(asset('/zakat_managment/Zakat-Leaflet-Bangla-v3.pdf')); ?>">Zakat Leaflet</a><br></li>
                    </ul>
                    <div class="pt-4 px-4 text-center">
                        <p class="text-[#212b36] pb-3 text-left"><strong>Why Donate Zakat</strong></p>
                        <iframe
                            width="100%"
                            height="200"
                            src="https://www.youtube.com/embed/egy8nwSO0Qc"
                            frameborder="0"
                            allowfullscreen>
                        </iframe>
                        <p class="pt-4 text-left">How a Muslim can donate Zakat for treatment purposes</p>
                    </div>
                    <h4 class="px-4 pt-5">Media coverage</h4>
                    

                    

                    <div class="max-w-2xl mx-auto bg-white   p-6">
                        <div class="faq-item border-b border-[#e9eff4] ">
                            <div
                                class="faq-question text-lg font-semibold text-[#212b36] cursor-pointer flex justify-between items-center">
                                <span>প্রথম আলো</span>
                                <span class="faq-icon">+</span>
                            </div>
                            <div class="faq-answer hidden mt-2 text-gray-700">
                                <div class="pb-2">
                                    <img class="mt-2 h-5 block" src="<?php echo e(asset('/assets/img/chart/prothom_alo.png')); ?>"
                                        alt="Prothom Alo Logo">
                                    <a href="https://www.prothomalo.com/bangladesh/0p8pbcqjf6">
                                        19 April 2023 - অদম্য হাসানের পাশে আমরা দাঁড়াতে পারি কি
                                    </a> <a
                                        href="<?php echo e(asset('/assets/img/zakat-coverage/zakat-coverage/2023-03-19_অদম্য হাসানের পাশে আমরা দাঁড়াতে পারি কি _ প্রথম আলো.pdf')); ?>">(pdf)</a><br>

                                    <a href="https://www.prothomalo.com/bangladesh/kvml3r2t8b">
                                        15 April 2023 - হার নয়, পরিবারটি চায় আপনার সহযোগিতা
                                    </a> <a
                                        href="<?php echo e(asset('/assets/img/zakat-coverage/zakat-coverage/2023-03-15_হার_নয়_পরিবারটি_চায়_আপনার_সহযোগিতা_প্রথম_আলো.pdf')); ?>">(pdf)</a><br>

                                    <a href="https://www.prothomalo.com/bangladesh/nclucs5lz2">
                                        01 April 2023 - ঘোর অনিশ্চয়তায় সুমাইয়া, তাকিয়ে আপনাদের দিকে
                                    </a> <a
                                        href="<?php echo e(asset('/assets/img/zakat-coverage/zakat-coverage/2023-03-01_ঘোর_অনিশ্চয়তায়_সুমাইয়া_তাকিয়ে_আপনাদের_দিকে_প্রথম_আলো.pdf')); ?>">(pdf)</a><br>
                                    <a
                                        href="https://www.prothomalo.com/bangladesh/দুরারোগ্য-ব্যাধিতে-আক্রান্ত-যমজ-সন্তান-সাহায্যের-আবেদন">
                                        27 April 2022 - দুরারোগ্য ব্যাধিতে আক্রান্ত যমজ সন্তান, সাহায্যের আবেদন
                                    </a> <a
                                        href="<?php echo e(asset('/assets/img/zakat-coverage/zakat-coverage/2022-04-27_দুরারোগ্য_ব্যাধিতে_আক্রান্ত_যমজ_সন্তান__সাহায্যের_আবেদন___প্রথম_আলো.pdf')); ?>">(pdf)</a><br>

                                    <a
                                        href="https://www.prothomalo.com/bangladesh/অসহায়-রোগীদের-চিকিৎসায়-আশার-আলো-থ্যালাসেমিয়া-ফাউন্ডেশনের-জাকাত-ফান্ড">
                                        23 April 2022 - অসহায় রোগীদের চিকিৎসায় আশার আলো থ্যালাসেমিয়া ফাউন্ডেশনের ‘জাকাত
                                        ফান্ড’
                                    </a> <a
                                        href="<?php echo e(asset('/assets/img/zakat-coverage/zakat-coverage/2022-04-23_অসহায়_রোগীদের_চিকিৎসায়_আশার_আলো_থ্যালাসেমিয়া_ফাউন্ডেশনের_জাকাত_ফান্ড___প্রথম_আলো.pdf')); ?>">(pdf)</a><br>

                                    <a
                                        href="https://www.prothomalo.com/bangladesh/বাবা-মেয়ে-দুজনই-থ্যালাসিমিয়া-রোগী-ওদের-বাঁচাতে-এগিয়ে-আসুন">
                                        19 April 2022 - বাবা-মেয়ে দুজনই থ্যালাসিমিয়া রোগী, ওদের বাঁচাতে এগিয়ে আসুন
                                    </a> <a
                                        href="<?php echo e(asset('/assets/img/zakat-coverage/zakat-coverage/2022-04-19_বাবা-মেয়ে_দুজনই_থ্যালাসিমিয়া_রোগী__ওদের_বাঁচাতে_এগিয়ে_আসুন___প্রথম_আলো.pdf')); ?>">(pdf)</a><br>

                                    <a
                                        href="https://www.prothomalo.com/bangladesh/এই-রমজানে-থ্যালাসেমিয়া-রোগীদের-জীবন-বাঁচাতে-জাকাত-দিন">
                                        09 April 2022 - এই রমজানে থ্যালাসেমিয়া রোগীদের জীবন বাঁচাতে জাকাত দিন
                                    </a> <a
                                        href="<?php echo e(asset('/assets/img/zakat-coverage/zakat-coverage/2022-04-09_এই_রমজানে_থ্যালাসেমিয়া_রোগীদের_জীবন_বাঁচাতে_জাকাত_দিন___প্রথম_আলো.pdf')); ?>">(pdf)</a><br>

                                </div>
                            </div>
                        </div>
                        <div class="faq-item border-b border-[#e9eff4] py-4">
                            <div
                                class="faq-question text-lg font-semibold text-[#212b36] cursor-pointer flex justify-between items-center">
                                <span>দি ডেইলি স্টার</span>
                                <span class="faq-icon">+</span>
                            </div>
                            <div class="faq-answer hidden mt-2 text-gray-700">
                                <div class="pb-2">
                                    <img class="mt-2 h-5 block" style=""
                                        src="<?php echo e(asset('/assets/img/chart/daily_star.svg')); ?>" alt="The Daily Star Logo">
                                    <a
                                        href="https://www.thedailystar.net/country/zakat-for-life-mission-save-lives-children-with-thalassemia-1903102">May
                                        16, 2020 - Zakat for life: A mission to save lives of children with thalassemia
                                    </a> <a
                                        href="<?php echo e(asset('/assets/img/zakat-coverage/zakat-coverage/2020-05-16_zakat_for_life_a_mission_to_save_lives_of_children_with_thalassemia_(updated).pdf')); ?>">(pdf)</a>

                                </div>
                            </div>
                        </div>
                        <div class="faq-item border-b border-[#e9eff4] py-4">
                            <div
                                class="faq-question text-lg font-semibold text-[#212b36] cursor-pointer flex justify-between items-center">
                                <span>যুগান্তর </span>
                                <span class="faq-icon">+</span>
                            </div>
                            <div class="faq-answer hidden mt-2 text-gray-700">
                                <div class="pb-2">
                                    <img class="mt-2 h-5 block" src="<?php echo e(asset('/assets/img/chart/jugantor.png')); ?>"
                                        alt="Jugantor Logo">

                                    <a
                                        href="https://www.jugantor.com/todays-paper/news/418107/থ্যালাসিমিয়া-আক্রান্ত-শিশুদের-সাহায্যে-এগিয়ে-আসুন">
                                        04 May 2021 - থ্যালাসিমিয়া আক্রান্ত শিশুদের সাহায্যে এগিয়ে আসুন
                                    </a> <a
                                        href="<?php echo e(asset('/assets/img/zakat-coverage/zakat-coverage/2021-05-04_থ্যালাসিমিয়া_আক্রান্ত_শিশুদের_সাহায্যে_এগিয়ে_আসুন.jpg')); ?>">(pdf)</a><br>

                                    <a
                                        href="https://www.jugantor.com/todays-paper/city/416193/নগদর-মাধ্যমে-জাকাত-দেয়ার-সুযোগ">
                                        28 April 2021 - ‘নগদ’র মাধ্যমে জাকাত দেয়ার সুযোগ
                                    </a> <a
                                        href="<?php echo e(asset('/assets/img/zakat-coverage/zakat-coverage/2021-04-28_‘নগদ’র_মাধ্যমে_জাকাত_দেয়ার_সুযোগ.pdf')); ?>">(pdf)</a>

                                    <a
                                        href="https://www.jugantor.com/todays-paper/news/182004/%E0%A6%9C%E0%A6%BE%E0%A6%95%E0%A6%BE%E0%A6%A4%E0%A7%87%E0%A6%B0-%E0%A6%85%E0%A6%B0%E0%A7%8D%E0%A6%A5%E0%A7%87-%E0%A6%AD%E0%A6%BE%E0%A6%B2%E0%A7%8B-%E0%A6%A5%E0%A6%BE%E0%A6%95%E0%A6%AC%E0%A7%87-%E0%A6%A6%E0%A6%B0%E0%A6%BF%E0%A6%A6%E0%A7%8D%E0%A6%B0-%E0%A6%A5%E0%A7%8D%E0%A6%AF%E0%A6%BE%E0%A6%B2%E0%A6%BE%E0%A6%B8%E0%A7%87%E0%A6%AE%E0%A6%BF%E0%A7%9F%E0%A6%BE-%E0%A6%B6%E0%A6%BF%E0%A6%B6%E0%A7%81?__cf_chl_jschl_tk__=de9e5478930d11377cf0c2a489f5966b3aabfd28-1588317567-0-AUeJIRIqpbZUrr0Ak7FTntJZ9VsYGQoCYjfJp2tJF9QMDfQm3DP7okP_IAWefqGOUzS_xPVfUBXvGmj2qmG3c-jdimDPHdnN59VlL8pr26FM2F77aWeuH0mJu6RqK9kAe4BvHk1-8Rynn6uYfwifKZ0rwTHg0DaxPH-nHJfYjVwd-A5J9NBKC529B3jpjCu40EixsxR2ufsi4GilKiOcI1HUXQLrFIM5PvbkL-zNWcR4XvLckkOunUpJl7pkixwP-nbXMmR7aEIoITl2K3N3AZe9zmlK9Il36mlLasLYnkT1oGkRk-X--Se0Q82cbSXoz439SBhKC4nQLZ3hY8qIMf2q1NAnCvnoyucmuBSN7sLGJtg4Wh0c-KoXeB0i1YqfnV0caxLvcqkrq7ft5WPCSIV72gzV7LnGydnn5B4BllRuwh9iZoT7ChYBV96ckMrVgrPttIwu_tEey9EY6d9Rfl93eC-O-wvgP7B_rAMm4ulklHy4GVh-pEKIa4xKlLrfR5Ji0w2AB9-NyAy6v7Httwn7OuuAt-lbxiwzTQWlXGTIp0zzht8IL7GDshSQGIRNpDzUYqDTgnY4NVN-OFzIVG-6SN7mW7c39EK1lj38jwafHuWCGxPhlZ5tu_feSrFjTpIRGAquD4hm0mISWs0kVqYSI8wJB4B6bvl_FdZNj8rUBhTTtMtqD7dchiRSBe25GymDGNvU_W10j4BAiG7ChW0H-gyW8PVHJRuFjSgcg8S9INLTc53nFPQVhkd3Le8o-9y9rsJXx00P2sJiqSi6UOM7go8FiUUeh87wOBP0CXMJTGqunUdWrnTZw5A4Q2yukw">May
                                        28, 2019 - জাকাতের অর্থে ভালো থাকবে দরিদ্র থ্যালাসেমিয়া শিশু</a> <a
                                        href="<?php echo e(asset('/assets/img/zakat-coverage/zakat-coverage/2019-05-27_jugantor_যাকাতের_অর্থে_ভাল_থাকবে_দরিদ্র_থ্যালাসেমিয়া_শিশু.jpg')); ?>">(pdf)</a>

                                </div>
                            </div>
                        </div>
                        <div class="faq-item border-b border-[#e9eff4] py-4">
                            <div
                                class="faq-question text-lg font-semibold text-[#212b36] cursor-pointer flex justify-between items-center">
                                <span>আমাদের সময়</span>
                                <span class="faq-icon">+</span>
                            </div>
                            <div class="faq-answer hidden mt-2 text-gray-700">

                                <div class="pb-2">
                                    <img class="mt-2 h-5 block" src="<?php echo e(asset('/assets/img/chart/amader_somoy.jpg')); ?>"
                                        alt="Amader Somoy Logo">
                                    June 03, 2019 - দরিদ্র থ্যালাসেমিয়া রোগীদের জীবন বাঁচাতে জাকাত দিন <a
                                        class="hover:text-primary duration-500"
                                        href="<?php echo e(asset('/assets/img/zakat-coverage/zakat-coverage/2019-06-03_amader_somoy_থ্যালাসেমিয়া_রোগীর_জীবন_বাঁচাতে_যাকাত_দিন.jpeg')); ?>">(pdf)</a><br>
                                </div>
                            </div>
                        </div>
                        <div class="faq-item border-b border-[#e9eff4] py-4">
                            <div
                                class="faq-question text-lg font-semibold text-[#212b36] cursor-pointer flex justify-between items-center">
                                <span>বাংলা নিউস ২৪</span>
                                <span class="faq-icon">+</span>
                            </div>
                            <div class="faq-answer hidden mt-2 text-gray-700">
                                <div class="pb-2">
                                    <img class="mt-2 h-5 block" src="<?php echo e(asset('/assets/img/chart/banglanews.jpg')); ?>"
                                        alt="Banglanews24 Logo">
                                    <a href="https://www.banglanews24.com/health/news/bd/718252.details">May 23, 2019 -
                                        যাকাতের অর্থে ভালো থাকবে
                                        দরিদ্র
                                        থ্যালাসেমিয়া শিশুরা</a> <a
                                        href="<?php echo e(asset('/assets/img/zakat-coverage/zakat-coverage/2019-05-23_banglanews24_যাকাতের_অর্থে_ভালো_থাকবে_দরিদ্র_থ্যালাসেমিয়া_শিশুরা.pdf')); ?>">(pdf)</a>
                                </div>
                            </div>
                        </div>

                        <div class="faq-item border-b border-[#e9eff4] py-4">
                            <div
                                class="faq-question text-lg font-semibold text-[#212b36] cursor-pointer flex justify-between items-center">
                                <span>বাংলা ট্রিবিউন </span>
                                <span class="faq-icon">+</span>
                            </div>
                            <div class="faq-answer hidden mt-2 text-gray-700">
                                <div class="pb-2">
                                    <img class="mt-2 h-5 block" src="<?php echo e(asset('/assets/img/chart/banglatribute.png')); ?>"
                                        alt="Bangla Tribune Logo">
                                    <a
                                        href="https://www.banglatribune.com/others/news/333431/https/www.dw.com/bn/%E0%A6%AC%E0%A6%BF%E0%A6%B7%E0%A7%9F/s-11929">June
                                        12, 2018 - জাকাত দিয়ে থ্যালাসেমিয়া আক্রান্ত শিশুদের পাশে দাঁড়ানোর আহ্বান</a> <a
                                        href="<?php echo e(asset('/assets/img/zakat-coverage/zakat-coverage/2018-06-06_banglatribune_জাকাত_দিয়ে_থ্যালাসেমিয়া_আক্রান্ত_শিশুদের_পাশে_দাঁড়ানোর_আহ্বান.pdf')); ?>">(pdf)</a>
                                </div>
                            </div>
                        </div>
                        <div class="faq-item border-b border-[#e9eff4] py-4">
                            <div
                                class="faq-question text-lg font-semibold text-[#212b36] cursor-pointer flex justify-between items-center">
                                <span>একুশে ই-টিভি </span>
                                <span class="faq-icon">+</span>
                            </div>
                            <div class="faq-answer hidden mt-2 text-gray-700">
                                <div class="pb-2">
                                    <img class="mt-2 h-5 block" src="<?php echo e(asset('/assets/img/chart/ekushey_tv.png')); ?>"
                                        alt="EkusheTV Logo">
                                    <a
                                        href="https://www.ekushey-tv.com/%E0%A6%9C%E0%A6%BE%E0%A6%95%E0%A6%BE%E0%A6%A4-%E0%A6%A6%E0%A6%BF%E0%A7%9F%E0%A7%87-%E0%A6%A6%E0%A6%B0%E0%A6%BF%E0%A6%A6%E0%A7%8D%E0%A6%B0-%E0%A6%A5%E0%A7%8D%E0%A6%AF%E0%A6%BE%E0%A6%B2%E0%A6%BE%E0%A6%B8%E0%A7%87%E0%A6%AE%E0%A6%BF%E0%A7%9F%E0%A6%BE-%E0%A6%B0%E0%A7%8B%E0%A6%97%E0%A7%80%E0%A6%A6%E0%A7%87%E0%A6%B0-%E0%A6%AA%E0%A6%BE%E0%A6%B6%E0%A7%87-%E0%A6%A6%E0%A6%BE%E0%A6%81%E0%A7%9C%E0%A6%BE%E0%A6%A8/38743">June
                                        10, 2018 - জাকাত দিয়ে দরিদ্র থ্যালাসেমিয়া রোগীদের পাশে দাঁড়ান</a> <a
                                        href="<?php echo e(asset('/images/newspaper/zakat-coverage/2018-06-10_ekushetv_জাকাত_দিয়ে_দরিদ্র_থ্যালাসেমিয়া_রোগীদের_পাশে_দাঁড়ান.pdf')); ?>">(pdf)</a>
                                </div>
                            </div>
                        </div>
                        <div class="faq-item border-b border-[#e9eff4] py-4">
                            <div
                                class="faq-question text-lg font-semibold text-[#212b36] cursor-pointer flex justify-between items-center">
                                <span>ডাক্তার প্রতিদিন </span>
                                <span class="faq-icon">+</span>
                            </div>
                            <div class="faq-answer hidden mt-2 text-gray-700">
                                <div class="pb-2">
                                    <img class="mt-2 h-5 block" src="<?php echo e(asset('/assets/img/chart/daktarprotidin.png')); ?>"
                                        alt="Daktar Protidin Logo">
                                    <a
                                        href="https://daktarprotidin.com/column/2492/%E0%A6%A4%E0%A6%BE%E0%A6%A8%E0%A6%BF%E0%A7%9F%E0%A6%BE%E0%A6%B0-%E0%A6%9C%E0%A7%80%E0%A6%AC%E0%A6%A8-%E0%A6%AC%E0%A6%BE%E0%A6%81%E0%A6%9A%E0%A6%BE%E0%A6%A4%E0%A7%87-%E0%A6%9C%E0%A6%BE%E0%A6%95%E0%A6%BE%E0%A6%A4-%E0%A6%A6%E0%A6%BF%E0%A6%A8">June
                                        15, 2018 - তানিয়ার জীবন বাঁচাতে জাকাত দিন</a> <a
                                        href="<?php echo e(asset('/images/newspaper/zakat-coverage/2018-06-15_daktarprotidin_তানিয়ার জীবন বাঁচাতে জাকাত দিন.pdf')); ?>">(pdf)</a>
                                </div>
                            </div>
                        </div>
                        
                    </div>

                    

                </div>
                <!--About Zakat Fund-->

                <!--Impact-->
                <div class="bg-white py-4  min-lg:mt-0 min-lg:max-h-[1850px]">
                    <div class="flex justify-between items-center pb-4  border-b border-[#e9eff4] px-4 ">
                        <h4>Impact</h4>

                    </div>
                    <p class="pt-5 px-4 ">The zakat fund is the lifeline for a large number of our patients. The number of
                        beneficiary patients has increased steadily over the past few years. In 2023, 1614 patients received
                        treatment from the zakat fund. </p>
                    <div class="text-center px-4 ">
                        <img src="assets/img/chart/numberofzkat2024.jpg" alt="zakat collection" class="mt-5 ">
                        <p class="py-5">Number of beneficiary by year</p>
                    </div>
                    <p class=" pb-3 px-4 ">In addition to increase in patient number, the amount of help an individual
                        patient
                        gets has also increased significantly.</p>

                    <div class="text-center px-4 ">
                        <img src="assets/img/chart/average_amount_per_patient2024.png" alt="zakat collection" class="mt-5">
                        <p class="py-5">Average patient support per year</p>
                    </div>
                    <p class="px-4 ">We are committed to the transparent operation of the zakat fund. The zakat
                        distribution process is
                        maintained meticulously supervised by the zakat committee and audited annually by a public auditor.
                    </p>
                    <div class="text-center px-4 ">
                        <img src="assets/img/chart/zakatDisrtibution2024.jpg" alt="zakat collection" class="mt-5">
                        <p class="py-5">Zakat distribution by year</p>
                    </div>
                    <p class="px-4 ">We spend zakat for only two purposes, the treatment of poor Muslim patients and to
                        pay
                        for the zakat fundraising costs.</p>
                    <div class="text-center px-4 ">
                        <img src="assets/img/chart/fundraising2024.jpg" alt="zakat collection" class="mt-5">
                        <p class="py-5">Cost of zakat fundraising by year</p>
                    </div>

                    
                    
                    
                </div>
                <!--Impact-->
                <!--About Zakat Fund-->
                <div class="bg-white py-4  min-lg:mt-0 min-lg:max-h-[1750px]">
                    <div class="flex justify-between items-center pb-4  px-4 border-b border-[#e9eff4]">
                        <h4> How to donate?</h4>
                        <a href="<?php echo e(env('EXTERNAL_URL')); ?>/campaign/together-against-thalassemia-20"
                            class="btn btn-primary hidden lg:block xs:px-2 xs:text-[10px] px-4 hover:text-white"> I Want To
                            Donate</a>
                    </div>
                  
                    <p class="pt-5  px-4">You can donate online using a Visa, Mastercard, or American Express credit card.
                        You can also deposit or e-transfer to our bank accounts, or use bKash to make payment from your
                        mobile banking account.</p>
                    <div class="text-center mt-5 hidden min-md:block">
                        <a class="btn btn-primary mt-5 xs:px-[2px] xs:text-[10px] px-4 hover:text-white " href="<?php echo e(env('EXTERNAL_URL')); ?>/campaign/together-against-thalassemia-20"> Donate Online</a>
                    </div>
                    <div class="flex items-center justify-center mt-5">
                        <img src="assets/img/payment/visa.png" alt="visa" class="mt-5  px-4 h-10">
                        <img src="assets/img/payment/mastercard.png" alt="mastercard" class="mt-5 px-4 h-10">
                        <img src="assets/img/payment/amex.png" alt="amex" class="mt-5 px-4 h-10">
                    </div>
                    <div class="px-4 py-5">
                        <h4 class="mt-5">Bank Accounts</h4>
                        <p class="mt-5">
                            Account Name: Bangladesh Thalassemia Foundation – Zakat Fund
                        </p>
                        <p class="mt-5 text-primary hover:text-[#b68023]"><a href="<?php echo e(url('/banks')); ?>">All bank
                                accounts</a></p>
                        <div class="mt-5">
                            <p><b>Dutch-Bangla Bank Limited</b><br></p>
                            <p>Shantinagar Branch, Dhaka </p>
                            <p> AC# 1081100037703</p>
                            <p>Routing no: 090276349 </p>
                            <p> Swift code: DBBLBDDH </p>
                        </div>
                        <div class="mt-5">
                            <p><b>Standard Chartered Bank</b> <br></p>
                            <p>Gulshan Branch, Dhaka</p>
                            <p>AC# 01130994802</p>
                            <p>Routing no: 215261726</p>
                            <p>Swift code: SCBLBDDX</p>
                        </div>
                        <div class="mt-5">
                            <p><b>IFIC Bank Limited</b></p>
                            <p>Shantinagar Branch, Dhaka</p>
                            <p>AC# 1007276293001</p>
                            <p>Routing no: 120276343</p>
                            <p>Swift code: IFICBDDH</p>

                        </div>
                        <div class="mt-5">
                            <p><b>Islami Bank Bangladesh Limited</b></p>
                            <p>Mouchak Branch, Dhaka</p>
                            <p>AC# 20501450100519315</p>
                            <p>Routing no: 125274395</p>
                            <p>Swift code: IBBLBDDH</p>
                        </div>

                        <h4 class="pt-5">Mobile Financial Service</h4>
                        <p><b>Bkash Merchant Account</b>: 01729284257</p>
                        <p class="pb-5"> (Dial *247# and use menu 4-Payment, counter '0’)</p>
                        <p> <b>Nagad Merchant Account</b>: 01729284257</p>
                        <p class="pb-5"> (Dial *167# and use menu 4-Payment)</p>
                        <p> <b>Upay Merchant Account</b>: 01729284257</p>
                        <p class="pb-5"> (Dial *268# and use menu 3-Make Payment)</p>
                        <p> <b>Rocket Merchant Account</b>: 017292842571</p>
                        <p class="pb-5"> (Dial *322# and use menu 8-Merchant Pay)</p>
                        <p><b>Tap Merchant Account</b>: 017292842571</p>
                        <p> (Dial *733# and use menu 7-Payment, counter '0’)</p>
                    </div>
                    
                    
                    



                    

                </div>
            </div>
            <!-- Main Content Wrapper-->
            <!-- Other Zakat Information Link -->
            

        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        document.querySelectorAll('.faq-question').forEach(item => {
            item.addEventListener('click', () => {
                const answer = item.nextElementSibling;
                const icon = item.querySelector('.faq-icon');

                // Toggle the 'show' class for fade-in/fade-out effect
                answer.classList.toggle('show');

                // Toggle icon between + and -
                icon.textContent = answer.classList.contains('show') ? '-' : '+';
            });
        });

        const donateButton = document.getElementById('donateButton');

        window.addEventListener('scroll', () => {
            // Check scroll position
            if (window.scrollY > 200) {
                donateButton.classList.add('show');
            } else {
                donateButton.classList.remove('show');
            }
        });

        document.getElementById('donateButton').addEventListener('click', function() {
            const paymentMethod = document.querySelector('#app payment-method');
            if (paymentMethod) {
                // Try focusing on the first input/button inside the payment-method
                const focusableElement = paymentMethod.querySelector('input, button, select, textarea, a');
                if (focusableElement) {
                    focusableElement.scrollIntoView({
                        behavior: 'smooth'
                    });
                    focusableElement.focus();
                } else {
                    paymentMethod.scrollIntoView({
                        behavior: 'smooth'
                    });
                }
            } else {
                console.warn('Payment method component not found');
            }
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\Web\thalsprojectweb\resources\views/zakatForLife/zakatForLife.blade.php ENDPATH**/ ?>