import defaultTheme from "tailwindcss/defaultTheme";

/** @type {import('tailwindcss').Config} */
export default {
    content: [
        "./vendor/laravel/framework/src/Illuminate/Pagination/resources/views/*.blade.php",
        "./storage/framework/views/*.php",
        "./resources/**/*.blade.php",
        "./resources/**/*.js",
        "./resources/**/*.vue",
    ],
    theme: {
        extend: {
            
            fontFamily: {
                sans: ["Outfit", ...defaultTheme.fontFamily.sans],
            },
            backgroundImage: {
                "bg-gradient":
                    "linear-gradient(130deg, rgba(79, 138, 139, 0.4), rgba(33, 43, 54, 0.6) 35%), linear-gradient(220deg, rgba(79, 138, 139, 0.6), rgba(33, 43, 54, 0.6) 27%), rgb(33, 43, 54)",
            },
            colors: {
                primary: '#ce1337',
                'primary-hover': 'rgb(206, 19, 55)',
                'primary-transparent': 'rgba(206, 19, 55, 0.082)',
                'hover-pink': 'rgba(233,30,99,0.1)',
                 textLight: '#212B36',
                // Add other unique colors here
                facebook: "rgb(58, 88, 155)",
                twitter: "rgb(3, 169, 244)",
                youtube: "#FF0000",
                white: "#ffffff",
                transparentWhite: "rgba(255, 255, 255, .06)",
                borderTable:'#D2D6E1'
            },
            boxShadow: {
                regular: '0 5px 20px rgba(206, 19, 55, 0.3)',
                common: '0px 2px 8px 0px rgba(99, 99, 99, 0.2)',
                focus: '0 0 0 1px rgba(13, 110, 253, 0.25)', // Mimics Bootstrap's shadow
                bgShadow: '0px 0px 10px rgba(70, 70, 70, 0.8)',
              },
            screens: {
                '5xl': { min: '1300px' },
                '4xl': { max: '1699px' },
                '3xl': { max: '1599px' },
                '2xl': { max: '1299px' },
                xl: { max: '1199px' },
                lg: { max: '991px' },
                md: { max: '767px' },
                sm: { max: '575px' },
                ssm: { max: '480px' },
                xs: { max: '380px' },
                xxs: { max: '320px' },
                'min-xxs': '320px',
                'min-xs': '380px',
                'min-ssm': '480px',
                'min-sm': '575px',
                'min-md': '768px',
                'min-lg': '991px',
                'min-xl': '1199px',
                'min-2xl': '1299px',
                'min-3xl': '1599px',
                'min-4xl': '1699px',
              },
        },
    },
    plugins: [],
};
