import { defineConfig } from 'vite';
import laravel from 'laravel-vite-plugin';
import vue from '@vitejs/plugin-vue';

export default defineConfig({
    plugins: [
        laravel({
            input: [
                'resources/sass/app.scss',
                'resources/js/app.js',
            ],
            refresh: true,
        }),
        vue({
            template: {
                transformAssetUrls: {
                    base: null,
                    includeAbsolute: false,
                },
            },
        }),
    ],
    resolve: {
        alias: {
            vue: 'vue/dist/vue.esm-bundler.js', // Ensure Vue uses the correct build for bundling
            'vue-spinners': 'vue-spinners/dist/vue-spinners.es.js', // Resolve vue-spinners package correctly
        },
    },
    server: {
        proxy: {
            '/app': 'http://localhost', // Useful if you're working with a Laravel backend in development
        },
    },
    build: {
        outDir: 'public/build', // Ensure build assets are output to Laravel's public directory
    },
});
