<?php

namespace App\Http\Controllers;

use Carbon\Carbon;
use Illuminate\Http\Request;

use Illuminate\Support\Facades\Log;
use App\Services\VisaExchangeRateService;
use App\Http\Requests\CurrencyRateRequest;
use App\Services\CurrencyConverterService;

class CurrencyConverterApiController extends Controller
{

    protected $currencyConverterService;

    // Inject the service into the controller's constructor
    public function __construct(CurrencyConverterService $currencyConverterService )
    {
        $this->currencyConverterService = $currencyConverterService;
      
    }

    public function getConversionRate(CurrencyRateRequest $request)
    {
        $baseCurrency = 'BDT'; // Fixed base currency
        $quoteCurrency = $request->input('quote_currency');

        $result = $this->currencyConverterService->getConversionRate($baseCurrency, $quoteCurrency);

        if ($result['status'] === 'error') {
            return response()->json($result, 500);
        }

        return response()->json([
            'status' => 'success',
            'source' => $result['source'],
            'conversion_rate' => $result['rate'],
            'date' => $result['date']
        ]);
    }

    
    
    // public function showExchangeRate()
    // {
    //     // Example of calling the service to get the exchange rate
    //     $exchangeRate = $this->visaExchangeRateService->getExchangeRate(1, 0, "09%2F17%2F2024", "09%2F17%2F2024", "BDT", "USD");

    //     // Return response as JSON
    //     return response()->json($exchangeRate);
    // }
}
