<template>
  <div id="app">
    <button @click="toggleLoading">Toggle Loader</button>
    
    <!-- Include the CSS loader component -->
    <css-loader :isLoading="loading" />
  </div>
</template>

<script>
// Import the CssLoader component
import CssLoader from './CssLoader.vue';

export default {
  data() {
    return {
      loading: false, // Initially the loader is hidden
    };
  },
  components: {
    CssLoader, // Register the CssLoader component
  },
  methods: {
    toggleLoading() {
      // Toggle the loading state when the button is clicked
      this.loading = !this.loading;
    },
  },
};
</script>

<style>
#app {
  display: flex;
  justify-content: center;
  align-items: center;
  height: 100vh;
  flex-direction: column;
  text-align: center;
}

button {
  padding: 10px 20px;
  font-size: 16px;
  cursor: pointer;
  background-color: #ce1337;
  color: white;
  border: none;
  border-radius: 5px;
}
</style>
