<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class BloodDonorRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'first_name'    => 'required|string|max:255',
            'last_name'     => 'required|string|max:255',
            'blood_group'   => 'required|string',
            'date_of_birth' => 'required|date_format:d/m/Y',
            'gender'           => 'required|string|in:Male,Female,Other',
            'email'         => 'required|email|unique:donors,email',
            'mobile' => ['required', 'string', 'regex:/^(?:\d{11}|\d{14})$/'],
            'district'      => 'required|string|max:255',
            'latitude'      => 'nullable|numeric',
            'longitude'     => 'nullable|numeric',
        ];
    }
}
