<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('credit_card_currency_rates', function (Blueprint $table) {
            $table->id();
            $table->date('quote_date')->nullable();
            $table->string('base_currency', 3)->nullable();
            $table->string('quote_currency', 3)->nullable();
            $table->double('conversion_rate')->nullable();
            $table->string('data_source')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('credit_card_currency_rates');
    }
};
