import { mergeProps as _mergeProps, createVNode as _createVNode, Fragment as _Fragment } from "vue";
// Styles
import "./VTreeviewItem.css";

// Components
import { VBtn } from "../../components/VBtn/index.mjs";
import { VListItemAction } from "../../components/VList/index.mjs";
import { makeVListItemProps, VListItem } from "../../components/VList/VListItem.mjs";
import { VProgressCircular } from "../../components/VProgressCircular/index.mjs"; // Composables
import { IconValue } from "../../composables/icons.mjs";
import { useLink } from "../../composables/router.mjs"; // Utilities
import { computed, inject, ref, toRaw } from 'vue';
import { EventProp, genericComponent, omit, propsFactory, useRender } from "../../util/index.mjs"; // Types
import { VTreeviewSymbol } from "./shared.mjs";
export const makeVTreeviewItemProps = propsFactory({
  loading: Boolean,
  onToggleExpand: EventProp(),
  toggleIcon: IconValue,
  ...makeVListItemProps({
    slim: true
  })
}, 'VTreeviewItem');
export const VTreeviewItem = genericComponent()({
  name: 'VTreeviewItem',
  props: makeVTreeviewItemProps(),
  setup(props, _ref) {
    let {
      attrs,
      slots,
      emit
    } = _ref;
    const link = useLink(props, attrs);
    const vListItemRef = ref();
    const isActivatableGroupActivator = computed(() => vListItemRef.value?.root.activatable.value && vListItemRef.value?.isGroupActivator);
    const isClickable = computed(() => !props.disabled && props.link !== false && (props.link || link.isClickable.value || props.value != null && !!vListItemRef.value?.list || isActivatableGroupActivator.value));
    function activateGroupActivator(e) {
      if (isClickable.value && isActivatableGroupActivator.value) {
        vListItemRef.value?.activate(!vListItemRef.value?.isActivated, e);
      }
    }
    const visibleIds = inject(VTreeviewSymbol, {
      visibleIds: ref()
    }).visibleIds;
    useRender(() => {
      const listItemProps = omit(VListItem.filterProps(props), ['onClick']);
      const hasPrepend = slots.prepend || props.toggleIcon;
      return _createVNode(VListItem, _mergeProps({
        "ref": vListItemRef
      }, listItemProps, {
        "active": vListItemRef.value?.isActivated,
        "class": ['v-treeview-item', {
          'v-treeview-item--activatable-group-activator': isActivatableGroupActivator.value,
          'v-treeview-item--filtered': visibleIds.value && !visibleIds.value.has(toRaw(vListItemRef.value?.id))
        }, props.class],
        "ripple": false,
        "onClick": props.onClick ?? activateGroupActivator
      }), {
        ...slots,
        prepend: hasPrepend ? slotProps => {
          return _createVNode(_Fragment, null, [_createVNode(VListItemAction, {
            "start": false
          }, {
            default: () => [props.toggleIcon && _createVNode(VBtn, {
              "density": "compact",
              "icon": props.toggleIcon,
              "loading": props.loading,
              "variant": "text",
              "onClick": props.onToggleExpand
            }, {
              loader() {
                return _createVNode(VProgressCircular, {
                  "indeterminate": "disable-shrink",
                  "size": "20",
                  "width": "2"
                }, null);
              }
            })]
          }), slots.prepend?.(slotProps)]);
        } : undefined
      });
    });
    return {};
  }
});
//# sourceMappingURL=VTreeviewItem.mjs.map