// JavaScript to show and close the popup
window.onload = function () {
    const popup = document.getElementById("popup");
    const closeBtn = document.getElementById("popup-close");

    // Function to show the popup
    function showPopup() {
        popup.classList.remove("hidden");
        // Automatically hide the popup after 10 seconds
        setTimeout(() => {
            popup.classList.add("hidden");
        }, 10000);
    }

    document.addEventListener("DOMContentLoaded", function () {
        const header = document.querySelector(".header");

        window.addEventListener("scroll", function () {
            if (window.scrollY > 200) {
                header.classList.add("sticky");
                header.classList.remove("slide-out");
            } else {
                header.classList.add("slide-out");
                header.classList.remove("sticky");
            }
        });
    });

    // Check if the current page is the home page
    if (window.location.pathname === "/") {
        const lastClosedTime = localStorage.getItem("popupClosedTime");
        const currentTime = new Date().getTime();

        // Show the popup if 10 minutes have passed since the last close or if it's the first visit
        if (
            !lastClosedTime ||
            currentTime - lastClosedTime > 2 * 24 * 60 * 60 * 1000
        ) {
            showPopup();
        }

        // Allow the user to manually close the popup
        closeBtn.addEventListener("click", function () {
            popup.classList.add("hidden");
            // Save the current time in local storage
            localStorage.setItem("popupClosedTime", new Date().getTime());
        });
    }
};

// In your Javascript (external .js resource or <script> tag)
$(document).ready(function () {
    // Initialize Select2 on the select element
    $("#thalassemia-select").select2({
        placeholder: "Select Type of Thalassemia",
        allowClear: true,
        width: "100%", // Ensures it matches the parent's width
    });

    const menuBtn = document.getElementById("menuBtn");
    const closeBtn = document.getElementById("closeBtn");
    const menuBar = document.getElementById("menuBar");

    // Show the menu
    // menuBtn.addEventListener('click', () => {
    //     menuBar.classList.remove('lg:hidden'); // Remove hidden to make it visible
    //     requestAnimationFrame(() => { // Delay transform to allow visibility
    //         menuBar.classList.remove('lg:-translate-x-full');
    //     });
    // });
    if (menuBtn && menuBar) {
        menuBtn.addEventListener("click", () => {
            menuBar.classList.remove("lg:hidden"); // Remove hidden to make it visible
            requestAnimationFrame(() => {
                // Delay transform to allow visibility
                menuBar.classList.remove("lg:-translate-x-full");
            });
        });
    }

    // Hide the menu
    closeBtn.addEventListener("click", () => {
        menuBar.classList.add("lg:-translate-x-full"); // Slide out
        // Wait for animation to finish before hiding completely
        menuBar.addEventListener(
            "transitionend",
            () => {
                menuBar.classList.add("lg:hidden");
            },
            { once: true }
        ); // Remove the event listener after it runs once
    });
});
