import "./bootstrap.js";
import { createApp } from "vue";
import { createVuetify } from "vuetify";
import * as components from "vuetify/components";
import * as directives from "vuetify/directives";
import { aliases, mdi } from "vuetify/iconsets/mdi";

// Import Vuetify styles and icons
import "vuetify/styles";
import "@mdi/font/css/materialdesignicons.css";

// Import components for your routes
import District from "./components/District.vue";
import DonorRegisterForm from "./components/DonorRegisterForm.vue";
import BloodGroup from "./components/BloodGroup.vue";
import CurrencyOption from "./components/CurrencyOption.vue";
import Country from "./components/Country.vue";
import PatientRegistrationForm from "./components/PatientRegistrationForm.vue";
import TypeOfThalassemiaSelect from "./components/TypeOfThalassemia.vue";
import PaymentMethod from "./components/PaymentMethod.vue";
import ZakatCalculator from "./components/ZakatCalculator.vue";
import PaymentModalForm from "./components/PaymentModalForm.vue";

// Create Vuetify instance with configuration
const vuetify = createVuetify({
    components,
    directives,
    icons: {
        defaultSet: "mdi",
        aliases,
        sets: {
            mdi,
        },
    },
    theme: {
        defaultTheme: "light",
    },
});

// Create the app instance
const app = createApp({});

// Register components
app.component("blood-group", BloodGroup);
app.component("currency-option", CurrencyOption);
app.component("country", Country);
app.component("district", District);
app.component("donor-register-form", DonorRegisterForm);
app.component("patient-registration-form", PatientRegistrationForm);
app.component("type-of-thalassemia-select", TypeOfThalassemiaSelect);
app.component("payment-method", PaymentMethod);
app.component("zakat-calculator", ZakatCalculator);
app.component("payment-modal-form", PaymentModalForm);

// Use Vuetify
app.use(vuetify);

// Mount the app to the DOM
app.mount("#app");
