import VueRouter from 'vue-router';
import Vuex from 'vuex';
import VueAxios from "vue-axios";

import PulseLoader from 'vue-spinner/src/PulseLoader.vue'
import DonorRegistrationForm from "./components/DonorRegistrationForm";
import DonorHistoryForm from "./components/DonorHistoryForm";
import ThankYou from "./components/ThankYou";

window.Vue.use(VueRouter);
window.Vue.use(Vuex);
window.Vue.use(VueAxios, axios)

window.Vue.component('pulse-loader', PulseLoader);

const store = new Vuex.Store({
    state: {
        newDonor: {}
    },
    mutations: {

        donorRegistered(state, payload){
            state.newDonor = payload;
        }
    }
});

const routes =[
        {path: '/', component: DonorRegistrationForm},
        {path: '/donation-history', component: DonorHistoryForm},
        {path: '/thank-you', component: ThankYou},
    ];

const router = new VueRouter({routes});

let blood_donor_app = new window.Vue({
    router,
    store: store,
}).$mount('#blood_donor_app');

