@section('title', $title)
@section('description', $description)
@extends('layouts.app')


@section('content')
    <section class="max-width px-[3%] min-xl:mx-auto  min-xl:px-0">
        <!--Banner-->
        <div class="w-full pt-[98px]">
            <img src="{{ asset('assets/img/banner/zakat-cc-page-image-1-en-asmaul.jpg') }}" class="w-full"
                alt="zakat-cc-page-image-1-en-asmaul">
        </div>
        <!--Banner-->
        <!--Content-->
        <div class="min-lg:grid min-lg:grid-cols-[40%,55%] gap-5">
            <div class="bg-white shadow-common p-4 h-auto min-h-0">
                <h4 class="py-4">About Zakat Fund</h4>
                <p>
                    The Zakat Fund of Bangladesh Thalassemia Foundation provides life-saving treatment to poor and destitute
                    thalassemia patients from all around the country. It is the lifeline for a large number of patients. To
                    learn more, visit our
                    <a href="#" class="text-primary"> zakat fund page</a> You can donate us zakat in several ways.
                </p>

                <p class="pt-7">
                    <b>Bangladesh Thalassemia Foundation - Zakat Fund</b>
                </p>
                <ul class="pb-7">
                    <li>AC# 1081100037703</li>
                    <li> Dutch-Bangla Bank Limited</li>
                    <li>Shantinagar Branch, Dhaka</li>
                    <li>Routing no: 090276349</li>
                    <li>Swift code: DBBLBDDH</li>

                </ul>
                <a class="text-primary" href="{{ url('/banks') }}">See all bank accounts</a>

                <p class="py-7">
                    <b>Bkash/Nagad/Upay:</b> 01729284257<br>
                    (Marchant account. Use ‘Payment’ option, counter ‘0’)
                </p>

                <p>To donate online, please complete the form.</p>

                <div class="flex py-4 gap-5">
                    <img src="{{ asset('assets/img/payment/visa.png') }}" alt="visa" class="h-[50px] w-[80px]">
                    <img src="{{ asset('assets/img/payment/mastercard.png') }}" alt="mastercard" class="h-[50px] w-[80px]">
                    <img src="{{ asset('assets/img/payment/amex.png') }}" alt="amex" class="h-[50px] w-[80px]">
                </div>
            </div>



            <div class="p-4 bg-white shadow-common mt-4 mb-5 ">
                <form class="space-y-7">
                    <div class="relative w-full">
                        <!-- Label -->
                        <label for="input" class="absolute -top-2 left-3 bg-white text-sm text-gray-500 px-1">
                            Currency <span class="text-primary">*</span>
                        </label>

                        <!-- Select Dropdown -->
                        <select id="input" class="from-control-select">
                            <option value="AUD">AUD ($)</option>
                            <option value="BDT" selected="selected">BDT (৳)</option>
                            <option value="CAD">CAD ($)</option>
                            <option value="EUR">EUR (€)</option>
                            <option value="GBP">GBP (£)</option>
                            <option value="JPY">JPY (¥)</option>
                            <option value="USD">USD ($)</option>
                        </select>
                    </div>

                    <div class="relative w-full ">
                        <!-- Label -->
                        <label for="input" class="absolute -top-2 left-3 bg-white text-sm text-gray-500 px-1">
                            Custom amount <span class="text-primary">*</span>
                        </label>
                        <div class="from-control flex  flex-wrap gap-x-1">
                            <!-- Input Field -->
                            <button type="button" class="amount-btn">1000</button>
                            <button type="button" class="amount-btn">2000</button>
                            <button type="button" class="amount-btn">5000</button>
                            <button type="button" class="amount-btn">10000</button>
                            <button type="button" class="amount-btn">20000</button>
                            <button type="button" class="amount-btn">25000</button>
                        </div>
                    </div>

                    <div class="relative w-full ">
                        <!-- Label -->
                        <label for="input" class="absolute -top-2 left-3 bg-white text-sm text-gray-500 px-1">
                            Custom amount <span class="text-primary">*</span>
                        </label>
                        <div class="from-control">
                            <!-- Input Field -->
                            <input id="input" type="number" placeholder="Your Name"
                                class="flex-1 focus:outline-none placeholder-gray-400" required />
                        </div>
                        <p class="w-full bg-[#fcf8e3] px-3 mt-2 py-3">Equivalent amount in Bangladeshi Taka <b>(BDT
                                5000)</b> will be charged from your card.</p>
                    </div>
                    <div class="relative w-full ">
                        <!-- Label -->
                        <label for="input" class="absolute -top-2 left-3 bg-white text-sm text-gray-500 px-1">
                            Your Name <span class="text-primary">*</span>
                        </label>
                        <div class="from-control">
                            <!-- Input Field -->
                            <input id="input" type="text" placeholder="Your Name"
                                class="flex-1 focus:outline-none placeholder-gray-400" required />
                        </div>
                    </div>
                    <div class="relative w-full ">
                        <!-- Label -->
                        <label for="input" class="absolute -top-2 left-3 bg-white text-sm text-gray-500 px-1">
                            E-Mail Address <span class="text-primary">*</span>
                        </label>
                        <div class="from-control">
                            <!-- Input Field -->
                            <input id="input" type="email" placeholder="E-Mail Address"
                                class="flex-1 focus:outline-none placeholder-gray-400" required />
                        </div>
                    </div>

                    <div class="relative w-full ">
                        <!-- Label -->
                        <label for="input" class="absolute -top-2 left-3 bg-white text-sm text-gray-500 px-1">
                            Mobile Number <span class="text-primary">*</span>
                        </label>
                        <div class="from-control">
                            <!-- Input Field -->
                            <input id="input" type="text" placeholder="Mobile Number"
                                class="flex-1 focus:outline-none placeholder-gray-400" required />
                        </div>
                    </div>

                    <div class="relative w-full ">
                        <!-- Label -->
                        <label for="input" class="absolute -top-2 left-3 bg-white text-sm text-gray-500 px-1">
                            Address Line 1 <span class="text-primary">*</span>
                        </label>
                        <div class="from-control">
                            <!-- Input Field -->
                            <input id="input" type="text" placeholder="Address Line 1"
                                class="flex-1 focus:outline-none placeholder-gray-400" required />
                        </div>
                    </div>

                    <div class="relative w-full ">
                        <!-- Label -->
                        <label for="input" class="absolute -top-2 left-3 bg-white text-sm text-gray-500 px-1">
                            Address Line 2 <span class="text-primary">*</span>
                        </label>
                        <div class="from-control">
                            <!-- Input Field -->
                            <input id="input" type="text" placeholder="Address Line 2"
                                class="flex-1 focus:outline-none placeholder-gray-400" required />
                        </div>
                    </div>

                    <div class="relative w-full ">
                        <!-- Label -->
                        <label for="input" class="absolute -top-2 left-3 bg-white text-sm text-gray-500 px-1">
                            City <span class="text-primary">*</span>
                        </label>
                        <div class="from-control">
                            <!-- Input Field -->
                            <input id="input" type="text" placeholder="City"
                                class="flex-1 focus:outline-none placeholder-gray-400" required />
                        </div>
                    </div>
                    <div class="relative w-full ">
                        <!-- Label -->
                        <label for="input" class="absolute -top-2 left-3 bg-white text-sm text-gray-500 px-1">
                            State / Province <span class="text-primary">*</span>
                        </label>
                        <div class="from-control">
                            <!-- Input Field -->
                            <input id="input" type="text" placeholder="State / Province"
                                class="flex-1 focus:outline-none placeholder-gray-400" required />
                        </div>
                    </div>

                    <div class="relative w-full ">
                        <!-- Label -->
                        <label for="input" class="absolute -top-2 left-3 bg-white text-sm text-gray-500 px-1">
                            Post Code / Zip Code <span class="text-primary">*</span>
                        </label>
                        <div class="from-control">
                            <!-- Input Field -->
                            <input id="input" type="text" placeholder="Post Code / Zip Code"
                                class="flex-1 focus:outline-none placeholder-gray-400" required />
                        </div>
                    </div>

                    <div class="relative w-full ">
                        <!-- Label -->
                        <label for="input" class="absolute -top-2 left-3 bg-white text-sm text-gray-500 px-1">
                            Country <span class="text-primary">*</span>
                        </label>
                        <div class="from-control">
                            <!-- Input Field -->
                            <input id="input" type="text" placeholder="Country"
                                class="flex-1 focus:outline-none placeholder-gray-400" required />
                        </div>
                    </div>

                    <div class="relative w-full ">
                        <!-- Label -->
                        <label for="input" class="absolute -top-2 left-3 bg-white text-sm text-gray-500 px-1">
                            Select Credit Card <span class="text-primary">*</span>
                        </label>
                        <div class="from-control">
                            <!-- Input Field -->
                            <input id="input" type="text" placeholder="Select Credit Card"
                                class="flex-1 focus:outline-none placeholder-gray-400" required />
                        </div>
                    </div>
                    <div class="relative w-full ">
                        <!-- Label -->
                        <label for="input" class="absolute -top-2 left-3 bg-white text-sm text-gray-500 px-1">
                            Select Credit Card <span class="text-primary">*</span>
                        </label>
                        {{-- <div class="from-control flex  flex-wrap gap-x-1"> --}}
                        <!-- Input Field -->
                        <div id="cc_logos" class="from-control flex  flex-wrap gap-x-1 items-center">
                            <img onclick="selectEBL()" src="{{ asset('assets/img/payment/visa.svg') }}"
                                class="h-[40px] w-[80px] mt-4 border border-gray-300" alt="visa logo">
                            <img onclick="selectEBL()" src="{{ asset('assets/img/payment/mastercard.svg') }}"
                                class="h-[30px] w-[70px] border mt-4 border-gray-300" alt="mastercard logo">
                            <img onclick="selectCity()" src="{{ asset('assets/img/payment/amex.svg') }}"
                                class="h-[30px] w-[80px] mt-4 border border-gray-300" alt="amex logo">
                        </div>
                        {{-- </div> --}}
                    </div>
                    <button class="btn btn-primary">Proceed to Payment Screen</button>
                </form>
            </div>
        </div>
        </div>
        <!--Content-->
    </section>
@endsection
