@section('title', $title)
@section('description', $description)
@extends('layouts.app')

@section('content')
    <section class="bg-[#ffffff]">
        <div class="max-width px-[3%] max-w-7xl mx-auto  sm:px-6 lg:px-8 pb-11">
            <div class="">
                <h1 class="text-xl sm:text-2xl font-bold pt-4 text-center sm:text-left">{{ $title }}</h1>
                <div>
                    <h4 class="text-lg font-semibold mb-4">Islami Banks</h4>
                    <div class="overflow-x-auto">
                        <table class="w-full border border-gray-300">
                            <thead>
                                <tr>
                                    <th class="border border-gray-300 px-2 py-2 text-sm sm:text-base">Sl.</th>
                                    <th class="border border-gray-300 px-2 py-2 text-sm sm:text-base">Bank Name</th>
                                    <th class="border border-gray-300 px-2 py-2 text-sm sm:text-base">Branch Name</th>
                                    <th class="border border-gray-300 px-2 py-2 text-sm sm:text-base">District</th>
                                    <th class="border border-gray-300 px-2 py-2 text-sm sm:text-base">Account Name</th>
                                    <th class="border border-gray-300 px-2 py-2 text-sm sm:text-base">Account Number</th>
                                    <th class="border border-gray-300 px-2 py-2 text-sm sm:text-base">Routing no</th>
                                    <th class="border border-gray-300 px-2 py-2 text-sm sm:text-base">Swift code</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr class="hover:bg-red-700 hover:text-white">
                                    <td class="border border-gray-300 px-2 py-2 text-sm">1</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Al-Arafah Islami Bank Limited</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Mouchak</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Dhaka</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Bangladesh Thalassemia Foundation –
                                        Zakat Fund</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">0241020121633</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">15274397</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">ALARBDDH</td>
                                </tr>
                                <tr class="hover:bg-red-700 hover:text-white">
                                    <td class="border border-gray-300 px-2 py-2 text-sm">2</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Islami Bank Bangladesh Limited</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Mouchak</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Dhaka</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Bangladesh Thalassemia Foundation –
                                        Zakat Fund </td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">20501450100519315</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">125274395</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">IBBLBDDH</td>
                                </tr>
                                <tr class="hover:bg-red-700 hover:text-white">
                                    <td class="border border-gray-300 px-2 py-2 text-sm">3</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Global Islami Bank Ltd </td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Nayapaltan</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Dhaka</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Bangladesh Thalassemia Foundation –
                                        Zakat Fund </td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">0111100446579</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">300274873</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">NGBLBDDH</td>
                                </tr>
                                <tr class="hover:bg-red-700 hover:text-white">
                                    <td class="border border-gray-300 px-2 py-2 text-sm">4</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Shahjalal Islami Bank Limited</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Bijoynagar</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Dhaka</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Bangladesh Thalassemia Foundation –
                                        Zakat Fund</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">401811100006090</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">190271099</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">SJBLBDDH</td>
                                </tr>
                                <tr class="hover:bg-red-700 hover:text-white">
                                    <td class="border border-gray-300 px-2 py-2 text-sm">5</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Standard Bank Limited</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Topkhana Road</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Dhaka</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Bangladesh Thalassemia Foundation –
                                        Zakat Fund </td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">00533012257</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">210276732</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">SDBLBDDH</td>
                                </tr>
                                <!-- Repeat other rows -->
                            </tbody>
                        </table>
                    </div>
                </div>

                <div class="mt-5">
                    <h4 class="text-lg font-semibold mb-4">Government Banks</h4>
                    <div class="overflow-x-auto">
                        <table class="w-full border border-gray-300">
                            <thead>
                                <tr>
                                    <th class="border border-gray-300 px-2 py-2 text-sm sm:text-base">Sl.</th>
                                    <th class="border border-gray-300 px-2 py-2 text-sm sm:text-base">Bank Name</th>
                                    <th class="border border-gray-300 px-2 py-2 text-sm sm:text-base">Branch Name</th>
                                    <th class="border border-gray-300 px-2 py-2 text-sm sm:text-base">District</th>
                                    <th class="border border-gray-300 px-2 py-2 text-sm sm:text-base">Account Name</th>
                                    <th class="border border-gray-300 px-2 py-2 text-sm sm:text-base">Account Number</th>
                                    <th class="border border-gray-300 px-2 py-2 text-sm sm:text-base">Routing no</th>
                                    <th class="border border-gray-300 px-2 py-2 text-sm sm:text-base">Swift code</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr class="hover:bg-red-700 hover:text-white">
                                    <td class="border border-gray-300 px-2 py-2 text-sm">1</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Rupali Bank Limited</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Nayapaltan Corporate</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Dhaka</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Bangladesh Thalassemia Foundation –
                                        Zakat Fund </td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">0505020003739</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">185274872</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">RUPBBDDH</td>
                                </tr>
                                <!-- Repeat other rows -->
                            </tbody>
                        </table>
                    </div>
                </div>

                <div class="mt-5">
                    <h4 class="text-lg font-semibold mb-4">Commercial Banks</h4>
                    <div class="overflow-x-auto">
                        <table class="w-full border border-gray-300">
                            <thead>
                                <tr>
                                    <th class="border border-gray-300 px-2 py-2 text-sm sm:text-base">Sl.</th>
                                    <th class="border border-gray-300 px-2 py-2 text-sm sm:text-base">Bank Name</th>
                                    <th class="border border-gray-300 px-2 py-2 text-sm sm:text-base">Branch Name</th>
                                    <th class="border border-gray-300 px-2 py-2 text-sm sm:text-base">District</th>
                                    <th class="border border-gray-300 px-2 py-2 text-sm sm:text-base">Account Name</th>
                                    <th class="border border-gray-300 px-2 py-2 text-sm sm:text-base">Account Number</th>
                                    <th class="border border-gray-300 px-2 py-2 text-sm sm:text-base">Routing no</th>
                                    <th class="border border-gray-300 px-2 py-2 text-sm sm:text-base">Swift code</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr class="hover:bg-red-700 hover:text-white">
                                    <td class="border border-gray-300 px-2 py-2 text-sm">1</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">AB Bank Limited</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Malibagh</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Dhaka</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Bangladesh Thalassemia Foundation –
                                        Zakat Fund</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">4031787230000</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">20273941</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">ABBLBDDH</td>
                                </tr>
                                <tr class="hover:bg-red-700 hover:text-white">
                                    <td class="border border-gray-300 px-2 py-2 text-sm">2</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Bangladesh Commerce Bank Limited
                                    </td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Mouchak</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Dhaka</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Bangladesh Thalassemia Foundation
                                        – Zakat Fund</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">00321001061</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">030274369</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">BCBLBDDH</td>
                                </tr>
                                <tr class="hover:bg-red-700 hover:text-white">
                                    <td class="border border-gray-300 px-2 py-2 text-sm">3</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">BRAC Bank Limited</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Shantinagar</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Dhaka</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Bangladesh Thalassemia Foundation
                                        – Zakat Fund</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">1545204573430003</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">060274289</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">BRAKBDDH</td>
                                </tr>
                                <tr class="hover:bg-red-700 hover:text-white">
                                    <td class="border border-gray-300 px-2 py-2 text-sm">4</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">City Bank Limited</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Imamgonj</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Dhaka</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Bangladesh Thalassemia Foundation
                                        – Zakat Fund</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">1402852353001</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">225272800</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">CIBLBDDH</td>
                                </tr>
                                <tr class="hover:bg-red-700 hover:text-white">
                                    <td class="border border-gray-300 px-2 py-2 text-sm">5</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Dhaka Bank Limited</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Kakrail</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Dhaka</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Bangladesh Thalassemia Foundation
                                        – Zakat Fund</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">1061090000145</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">085273373</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">DHBLBDDH</td>
                                </tr>
                                <tr class="hover:bg-red-700 hover:text-white">
                                    <td class="border border-gray-300 px-2 py-2 text-sm">6</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Dutch-Bangla Bank Limited</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Shantinagar</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Dhaka</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Bangladesh Thalassemia Foundation
                                        – Zakat Fund</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">1081100037703</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">090276349</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">DBBLBDDH</td>
                                </tr>
                                <tr class="hover:bg-red-700 hover:text-white">
                                    <td class="border border-gray-300 px-2 py-2 text-sm">7</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">IFIC Bank Limited</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Shantinagar</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Dhaka</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Bangladesh Thalassemia Foundation
                                        – Zakat Fund</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">1007276293001</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">120276343</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">IFICBDDH</td>
                                </tr>
                                <tr class="hover:bg-red-700 hover:text-white">
                                    <td class="border border-gray-300 px-2 py-2 text-sm">8</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Jamuna Bank Limited</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Shantinagar</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Dhaka</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Bangladesh Thalassemia Foundation
                                        – Zakat Fund</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">00090210012940</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">130276346</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">JAMUBDDH</td>
                                </tr>
                                <tr class="hover:bg-red-700 hover:text-white">
                                    <td class="border border-gray-300 px-2 py-2 text-sm">9</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Meghna Bank Limited</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Motijheel</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Dhaka</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Bangladesh Thalassemia Foundation
                                        – Zakat Fund</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">110313500000066</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">275274245</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">MGBLBDDH</td>
                                </tr>
                                <tr class="hover:bg-red-700 hover:text-white">
                                    <td class="border border-gray-300 px-2 py-2 text-sm">10</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Mercantile Bank Limited</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Bijoynagar</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Dhaka</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Bangladesh Thalassemia Foundation
                                        – Zakat Fund</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">1111000157077</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">140271094</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">MBLBBDDH</td>
                                </tr>
                                <tr class="hover:bg-red-700 hover:text-white">
                                    <td class="border border-gray-300 px-2 py-2 text-sm">11</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Midland Bank Limited</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Dilkusha</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Dhaka</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Bangladesh Thalassemia Foundation
                                        – Zakat Fund</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">00011050006892</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">285271933</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">MDBLBDDH</td>
                                </tr>
                                <tr class="hover:bg-red-700 hover:text-white">
                                    <td class="border border-gray-300 px-2 py-2 text-sm">12</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Modhumoti Bank Limited</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">VIP Road</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Dhaka</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Bangladesh Thalassemia Foundation
                                        – Zakat Fund</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">113511100000076</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">295276852</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">MODHBDDH</td>
                                </tr>
                                <tr class="hover:bg-red-700 hover:text-white">
                                    <td class="border border-gray-300 px-2 py-2 text-sm">13</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">National Credit & Commerce Bank
                                        Limited</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Dhanmondi</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Dhaka</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Bangladesh Thalassemia Foundation
                                        – Zakat Fund</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">00100210023284</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">160261189</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">NCCLBDDH</td>
                                </tr>
                                <tr class="hover:bg-red-700 hover:text-white">
                                    <td class="border border-gray-300 px-2 py-2 text-sm">14</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">NRB Bank Limited</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Dilkusha</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Dhaka</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Bangladesh Thalassemia Foundation
                                        – Zakat Fund</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">1081030058671</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">290271902</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">NRBDBDDH</td>
                                </tr>
                                <tr class="hover:bg-red-700 hover:text-white">
                                    <td class="border border-gray-300 px-2 py-2 text-sm">15</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">One Bank Limited</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Shantinagar</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Dhaka</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Bangladesh Thalassemia Foundation
                                        – Zakat Fund</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">1001020000640</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">165276340</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">ONEBBDDH</td>
                                </tr>
                                <tr class="hover:bg-red-700 hover:text-white">
                                    <td class="border border-gray-300 px-2 py-2 text-sm">16</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Premier Bank Limited</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Kakrail</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Dhaka</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Bangladesh Thalassemia Foundation
                                        – Zakat Fund</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">12411100008553</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">235273378</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">PRMRBDDH</td>
                                </tr>
                                <tr class="hover:bg-red-700 hover:text-white">
                                    <td class="border border-gray-300 px-2 py-2 text-sm">17</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Prime Bank Limited</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Mouchak</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Dhaka</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Bangladesh Thalassemia Foundation
                                        – Zakat Fund</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">2117139019028</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">170274395</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">PRBLBDDH</td>
                                </tr>
                                <tr class="hover:bg-red-700 hover:text-white">
                                    <td class="border border-gray-300 px-2 py-2 text-sm">18</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Shimanto Bank Ltd</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Principal</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Dhaka</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Bangladesh Thalassemia Foundation
                                        – Zakat Fund</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">1001271004251</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">305260211</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">SHMTBDDD</td>
                                </tr>
                                <tr class="hover:bg-red-700 hover:text-white">
                                    <td class="border border-gray-300 px-2 py-2 text-sm">19</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Standard Chartered Bank</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Gulshan</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Dhaka</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Bangladesh Thalassemia Foundation – Zakat Fund</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">01130994802</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">215261726</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">SCBLBDDX</td>
                                </tr>
                                <tr class="hover:bg-red-700 hover:text-white">
                                    <td class="border border-gray-300 px-2 py-2 text-sm">20</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Trust Bank Limited</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Kakrail</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Dhaka</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Bangladesh Thalassemia Foundation – Zakat Fund</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">00890210002017</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">240273376</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">TTBLBDDH</td>
                                </tr>
                                <tr class="hover:bg-red-700 hover:text-white">
                                    <td class="border border-gray-300 px-2 py-2 text-sm">21</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">United Commercial Bank Ltd</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Shantinagar</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Dhaka</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Bangladesh Thalassemia Foundation – Zakat Fund</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">0242101000010064</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">245273942</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">UCBLBDDH</td>
                                </tr>
                                <tr class="hover:bg-red-700 hover:text-white">
                                    <td class="border border-gray-300 px-2 py-2 text-sm">22</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Uttara Bank Limited</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Shantinagar</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Dhaka</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">Bangladesh Thalassemia Foundation – Zakat Fund</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">142012200215252</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">250276347</td>
                                    <td class="border border-gray-300 px-2 py-2 text-sm">UTBLBDDH</td>
                                </tr>
                                

                                <!-- Repeat other rows -->
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
