<!DOCTYPE html>
<html lang="en">

<head>
    
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title> Bangaldesh Thalassemia Foundation</title>
    <link rel="icon" type="img/png" href="<?php echo e(asset('favicon.png')); ?>">
    <link href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css" rel="stylesheet" />
    <!-- Select2 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://unpkg.com/@phosphor-icons/web"></script>

    <?php echo $__env->make('layouts.partials.google_site_tags', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('layouts.partials.google_analytics', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('layouts.partials.facebook_pixel', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('layouts.partials.hotjar_tracking', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('layouts.partials.linkedin_insight_tag', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('layouts.partials.microsoft_clarity', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


    <script>
        tailwind.config = {
            theme: {
                extend: {

                    fontFamily: {
                        sans: ["Outfit", "ui-sans-serif", "system-ui"],
                    },
                    backgroundImage: {
                        "bg-gradient": "linear-gradient(130deg, rgba(79, 138, 139, 0.4), rgba(33, 43, 54, 0.6) 35%), linear-gradient(220deg, rgba(79, 138, 139, 0.6), rgba(33, 43, 54, 0.6) 27%), rgb(33, 43, 54)",
                    },
                    colors: {

                        primary: '#ce1337 !important',
                        'primary-hover': 'rgb(206, 19, 55)',
                        'primary-transparent': 'rgba(206, 19, 55, 0.082)',
                        'hover-pink': 'rgba(233,30,99,0.1)',
                        textLight: '#212B36',
                        facebook: "rgb(58, 88, 155)",
                        twitter: "rgb(3, 169, 244)",
                        youtube: "#FF0000",
                        white: "#ffffff",
                        transparentWhite: "rgba(255, 255, 255, 0.06)",
                        borderTable: '#D2D6E1',
                    },
                    boxShadow: {
                        regular: '0 5px 20px rgba(206, 19, 55, 0.3)',
                        common: '0px 2px 8px 0px rgba(99, 99, 99, 0.2)',
                        focus: '0 0 0 1px rgba(13, 110, 253, 0.25)',
                        bgShadow: '0px 0px 10px rgba(70, 70, 70, 0.8)',
                    },
                    screens: {
                        '5xl': '1300px',
                        '4xl': {
                            max: '1699px'
                        },
                        '3xl': {
                            max: '1599px'
                        },
                        '2xl': {
                            max: '1299px'
                        },
                        xl: {
                            max: '1199px'
                        },
                        lg: {
                            max: '991px'
                        },
                        md: {
                            max: '767px'
                        },
                        sm: {
                            max: '575px'
                        },
                        ssm: {
                            max: '480px'
                        },
                        xs: {
                            max: '380px'
                        },
                        xxs: {
                            max: '320px'
                        },
                        'min-xxs': '320px',
                        'min-xs': '380px',
                        'min-ssm': '480px',
                        'min-sm': '575px',
                        'min-md': '768px',
                        'min-lg': '991px',
                        'min-xl': '1199px',
                        'min-2xl': '1299px',
                        'min-3xl': '1599px',
                        'min-4xl': '1699px',
                    },
                    safelist: [
                        'swiper-container',
                        'swiper-wrapper',
                        'swiper-slide',
                        'swiper-pagination',
                        'custom-button-next',
                        'custom-button-prev',
                    ],
                },
            },
        };
    </script>

    <style type="text/tailwindcss">
        :root {
            /* --v-theme-primary: unset; */
            /* সম্পূর্ণ রিমুভ করতে */
            /* অথবা নতুন কালার সেট করতে */
            /* --v-theme-primary: #ce1337; */
            /* লাল */
        }

        @layer utilities {

            /* CSS Code */
            .max-width {
                @apply max-w-[1100px]
            }


            h1,
            h2,
            h3,
            h4,
            h5,
            h6 {
                /* @apply color-red-500; */
                padding: 0;
                line-height: 1.1;
                font-weight: 400;
                word-wrap: break-word;
                font-family: "Outfit", ui-sans-serif, system-ui, sans-serif, ;
            }

            h1 {
                color: #212B36;
                font-size: 30px;
            }

            h2 {
                font-size: 36px;
                color: #212B36;
                font-weight: 500;
                line-height: 30px;
            }

            h3 {
                font-size: 28px;
                color: #212B36;
                font-weight: 500;
                line-height: 30px;
            }

            h4 {
                font-size: 24px;
                color: #212B36;
                font-weight: 500;
                line-height: 30px;
            }

            h5 {
                font-size: 18px;
                color: #212B36;
            }

            h6 {
                font-size: 14px;
                color: #212B36;
            }

            ul {
                color: #616D79;
            }

            label {
                font-size: 16px;
                color: #616D79;
            }

            p {
                font-size: 15px;
                color: #616D79;
                font-weight: 400;
                line-height: 24px;
                font-family: "Outfit", ui-sans-serif, system-ui, sans-serif, ;
            }

            li {
                font-size: 17px;
                line-height: 32px;
                font-family: "Outfit", ui-sans-serif, system-ui, sans-serif, ;
            }

            a {
                font-size: 15px;
                @apply text-primary;
                font-family: "Outfit", ui-sans-serif, system-ui, sans-serif, ;
                /* display: inline-block */
            }

            a:hover {
                @apply text-[#b68023] duration-500
            }

            .login-btn {
                @apply border border-primary text-primary px-4 py-2
            }

            /*BUTTON CSS  */
            .btn {
                @apply px-4 py-2 rounded-lg
            }

            .btn-primary {
                @apply bg-primary text-white
            }

            /* .btn-transparent {
                @apply bg-transparent text-primary border border-primary;
            } */

            .btn-transparent:hover {
                @apply bg-primary text-white shadow-regular duration-500;
            }

            .btn-primary:hover {
                @apply shadow-regular duration-500
            }

            .amount-btn {
                @apply bg-primary text-white px-2 py-1 rounded-lg mt-3 text-sm
            }

            /*BUTTON CSS  */

            /**INPUT CSS**/
            .from-control {
                @apply flex items-center w-full border border-gray-300 rounded-lg px-3 py-2
                /* text-gray-900  */
                focus-within:ring-[1px] focus-within:ring-[#ce1337] focus-within:border-transparent focus-within:shadow-sm duration-300
            }

            .from-control-select {
                @apply w-full border border-gray-300 rounded-lg px-3 py-2 text-gray-900 focus:ring-[1px] focus:ring-blue-500 focus:border-transparent focus:shadow-lg duration-300 outline-none focus:outline-none
            }

            /*HOME SLIDER CSS  */
            .swiper-wrapper {
                width: 100%;
                height: max-content !important;

                -webkit-transition-timing-function: linear !important;
                transition-timing-function: linear !important;
                position: relative;
            }

            .swiper-pagination-bullet {
                @apply bg-white
            }

            .custom-button-prev,
            .custom-button-next {
                position: absolute;
                z-index: 10;
                /* background-color: rgba(255, 255, 255, 0.8); Semi-transparent white background */
                border-radius: 50%;
                cursor: pointer;
                box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
            }

            .custom-button-prev {
                left: 10px;
            }

            .custom-button-next {
                right: 10px;
            }

            .custom-button-prev:hover,
            .custom-button-next:hover {
                @apply bg-primary;
                @apply text-primary
            }

            .custom-button-prev svg,
            .custom-button-next svg {
                width: 24px;
                height: 24px;
                transition: fill 0.3s;
            }

            /*HOME SLIDER CSS  */
            .footer-bg {
                background: linear-gradient(130deg,
                        rgba(79, 138, 139, 0.4),
                        rgba(33, 43, 54, 0.6) 35%),
                    linear-gradient(220deg,
                        rgba(79, 138, 139, 0.6),
                        rgba(33, 43, 54, 0.6) 27%),
                    rgb(33, 43, 54);
            }

            /***Responsive**/
            h2 {
                /* font-size: 36px; */
                @apply md:text-[32px]
            }

            h3 {
                /* font-size: 28px; */
                @apply md:text-[26px]
            }

            h4 {
                /* font-size: 24px; */
                @apply md:text-[22px]
            }

            /***Responsive**/

        }

        .sticky-button {
            transition:
                opacity 0.6s ease,
                visibility 0.6s ease,
                transform 0.6s cubic-bezier(0.25, 1, 0.5, 1);
            /* Slow, smooth slide-in effect */
            opacity: 0;
            visibility: hidden;
            transform: translateX(100%);
        }

        .sticky-button.show {
            opacity: 1;
            visibility: visible;
            transform: translateX(0);
        }

        /* Container styling */
        .select2-container--default .select2-selection--single {
            height: 42px;
            display: flex;
            align-items: center;
            padding: 0 10px;
            border: .5px solid #d1d5db;
            border-radius: 6px;
            background-color: #ffffff;
            font-size: 14px;
            color: #4b5563;
            transition: all 0.3s ease;
            box-shadow: 0 1px 2px rgba(0, 0, 0, 0.05);
            width: 100%;
        }

        /* Hover state for the dropdown */
        .select2-container--default .select2-selection--single:hover {
            border-color: #ce1337;
        }

        /* Placeholder styling */
        .select2-container--default .select2-selection__placeholder {
            color: #9ca3af;
            font-style: normal;
        }

        /* Dropdown arrow styling */
        .select2-container--default .select2-selection__arrow {
            height: 100%;
            top: 0;
            right: 15px;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        /* Dropdown menu */
        .select2-container--default .select2-dropdown {
            margin-top: 4px;
            border: 1px solid #d1d5db;
            border-radius: 6px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
            width: 100%;
        }

        /* Remove outline and change border for search input */
        .select2-container--default .select2-search--dropdown .select2-search__field {
            outline: none;
            border: 1px solid #ce1337;
            border-radius: 6px;
            padding: 6px 12px;
            font-size: 14px;
        }

        .select2-container--default .select2-search--dropdown .select2-search__field:focus {
            border: 1px solid #ce1337;
        }

        /* Dropdown items */
        .select2-container--default .select2-results__option {
            padding: 2px 15px;
            font-size: 14px;
            color: #374151;
            cursor: pointer;
            background-color: transparent;
            /* Remove background */
        }

        /* Hover effect for dropdown items */
        .select2-container--default .select2-results__option--highlighted {
            background-color: transparent;
            /* Remove background */
            color: #ce1337;
            /* Text color change on hover */
        }

        /* Selected item styling */
        .select2-container--default .select2-results__option--selected {
            background-color: transparent;
            /* Remove background */
            color: #ce1337;
            /* Text color for selected */
        }

        /* Focused state for input */
        .select2-container--default .select2-selection--single:focus {
            border-color: #ce1337;
            outline: none;
            box-shadow: 0 0 0 1px rgba(206, 19, 55, 0.1);
        }

        /* Selected option background and text color */
        .select2-container--default .select2-results__option--selected {
            background-color: #f3f4f6 !important;
            /* Light gray background */
            color: #4b5563 !important;
            /* Dark gray text color */
        }

        /* Hovered option background and text color */
        .select2-container--default .select2-results__option--highlighted {
            background-color: transparent !important;
            /* Light gray for hover */
            color: #ce1337 !important;
            /* Slightly darker text for hover */
        }

        .faq-answer {
            max-height: 0;
            overflow: hidden;
            opacity: 0;
            padding-top: 0;
            padding-bottom: 0;
            transition: max-height 0.5s ease-in-out, opacity 0.5s ease, padding 0.3s ease-in-out;
            display: block;
            visibility: hidden;
        }

        .faq-answer.show {
            max-height: 500px;
            /* Adjust based on content */
            padding-top: 10px;
            padding-bottom: 10px;
            opacity: 1;
            visibility: visible;
        }

        /* Initial header style */
        /* Initial header style */
        /* Initial header style */
        /* Header initial state */
        /* Header initial state */
        /* Initial header style */
        .header {
    position: fixed;
    top:0px; /* Initially hide header */
    left: 0;
    width: 100%;
    z-index: 1000;
    background-color: rgba(255, 255, 255, 0.95); /* Transparent background */
    backdrop-filter: blur(8px);
    box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
    padding: 15px 3%;
    transition: top 0.4s ease-in-out, background-color 0.3s ease-in-out;
}

/* Slide-in effect */
@keyframes slideIn {
    from {
        top: -100px; /* Start off-screen */
    }
    to {
        top: 0; /* Move to the top */
    }
}

/* Slide-out effect */
@keyframes slideOut {
    from {
        top: 0; /* Start at visible position */
    }
    to {
        top: -100px; /* Move out of the screen */
    }
}

/* Sticky header class */
.header.sticky {
    animation: slideIn 0.4s forwards; /* Slide in when sticky */
    background-color: rgba(255, 255, 255, 1); /* Solid background */
    box-shadow: 0 6px 10px rgba(0, 0, 0, 0.15); /* Add shadow when sticky */
    transition: none; /* Prevent conflict with animation */
}

/* Slide-out effect when scrolling back up */
.header.slide-out {
    animation: slideOut 0.4s forwards; /* Slide out */
    transition: none; /* Prevent conflict with animation */
}
    </style>
</head>

<body class="w-full h-full">
    <?php echo $__env->make('layouts.partials.google_site_tags_body', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div id="popup" class="fixed inset-0 bg-gray-800 bg-opacity-50 flex items-center justify-center hidden z-10">
        <div class="relative bg-white rounded-lg shadow-lg max-w-sm w-full">
            <!-- Top-right close icon -->
            <button id="popup-close" class="absolute top-2 right-2 text-white hover:text-gray-600">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24"
                    stroke="currentColor" stroke-width="2">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12" />
                </svg>
            </button>

            <!-- Welcome Image with Link -->
            <a href="<?php echo e(env('EXTERNAL_URL')); ?>/campaign/together-against-thalassemia-20">
                <img src="<?php echo e(asset('assets/img/welcome.jpeg')); ?>" alt="welcome" class="w-full rounded-lg">
            </a>
        </div>
    </div>


    <header class="">
        <?php echo $__env->make('partials._header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </header>
    <main class="">
        <?php echo $__env->yieldContent('content'); ?>
    </main>
    <footer>
        <?php echo $__env->make('partials._footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </footer>
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/jquery@3.5.1/dist/jquery.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

    <!--Icon-->
    <script src="https://unpkg.com/feather-icons"></script>
    <!-- Select2 JS -->

    <script src="<?php echo e(asset('js/script.min.js')); ?>"></script>
    <script src="<?php echo e(mix('js/app.js')); ?>"></script>
    
    <?php echo $__env->yieldContent('script'); ?>
</body>

</html>
<?php /**PATH E:\Web\thalsprojectweb\resources\views/layouts/app.blade.php ENDPATH**/ ?>