const mix = require('laravel-mix');
const webpack = require('webpack');
const path = require('path'); // Add this line at the top

mix.js('resources/js/app.js', 'public/js')
    .vue()  // Ensure Vue support is enabled
    .babelConfig({
        sourceType: 'module',
        presets: ['@babel/preset-env'],
    })
    .postCss('resources/css/app.css', 'public/css', [
        require('tailwindcss'),
        require('autoprefixer'),
    ])
    .styles([
        'node_modules/vue-loading-overlay/dist/css/index.css',
        'node_modules/vuetify/dist/vuetify.min.css',
        'node_modules/@mdi/font/css/materialdesignicons.min.css',
    ], 'public/css/app.css')
    .version()
    .webpackConfig({
        plugins: [
            new webpack.DefinePlugin({
                'process.env.MIX_MAPLE_BASE_URL': JSON.stringify(process.env.MIX_MAPLE_BASE_URL),
                'process.env.MIX_SELF_BASE_URL': JSON.stringify(process.env.MIX_SELF_BASE_URL),
                'process.env.MIX_VUE_APP_API_URL': JSON.stringify(process.env.MIX_VUE_APP_API_URL),
                
            }),
        ],
        resolve: {
            alias: {
                'vue$': 'vue/dist/vue.esm-bundler.js',
                '@': path.resolve(__dirname, 'resources/js'),
            }
        },
        module: {
            rules: [
                {
                    test: /\.mjs$/,
                    resolve: { fullySpecified: false },
                    include: /node_modules/,
                    type: 'javascript/auto'
                },
                {
                    test: /\.(woff|woff2|eot|ttf|otf)$/,
                    use: [
                        {
                            loader: 'file-loader',
                            options: {
                                name: '[name].[ext]',
                                outputPath: 'fonts/'
                            }
                        }
                    ]
                }
            ]
        }
    });

if (!mix.inProduction()) {
    mix.sourceMaps();
}